/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.net;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.metrics.metricsets.net.LinuxNetMetricManager;
import org.apache.iotdb.metrics.metricsets.net.MacNetMetricManager;
import org.apache.iotdb.metrics.metricsets.net.WindowsNetMetricManager;

public interface INetMetricManager {
    public static INetMetricManager getNetMetricManager() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return new WindowsNetMetricManager();
        }
        if (os.startsWith("linux")) {
            return new LinuxNetMetricManager();
        }
        return new MacNetMetricManager();
    }

    default public Map<String, Long> getReceivedByte() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getTransmittedBytes() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getReceivedPackets() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getTransmittedPackets() {
        return Collections.emptyMap();
    }

    default public Set<String> getIfaceSet() {
        return Collections.emptySet();
    }

    default public int getConnectionNum() {
        return 0;
    }
}

