/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.StartupChecks;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeStartupCheck
extends StartupChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeStartupCheck.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final int CONFIGNODE_PORTS = 2;

    public ConfigNodeStartupCheck(String nodeRole) {
        super(nodeRole);
    }

    protected void portCheck() throws StartupException {
        HashSet<Integer> portSet = new HashSet<Integer>();
        portSet.add(CONF.getConsensusPort());
        portSet.add(CONF.getInternalPort());
        if (portSet.size() != 2) {
            throw new StartupException("ports used in configNode have repeat.");
        }
        LOGGER.info("configNode port check successful.");
    }

    public void startUpCheck() throws StartupException, IOException, ConfigurationException {
        this.envCheck();
        this.portCheck();
        this.verify();
        this.checkGlobalConfig();
        this.createDirsIfNecessary();
        if (SystemPropertiesUtils.isRestarted()) {
            CONF.setClusterName(SystemPropertiesUtils.loadClusterNameWhenRestarted());
            CONF.setConfigNodeId(SystemPropertiesUtils.loadConfigNodeIdWhenRestarted());
            SystemPropertiesUtils.checkSystemProperties();
        }
    }

    private void checkGlobalConfig() throws ConfigurationException {
        if (CONF.getConfigNodeConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus") && (!CONF.getInternalAddress().equals(CONF.getTargetConfigNode().getIp()) || CONF.getInternalPort() != CONF.getTargetConfigNode().getPort())) {
            throw new ConfigurationException("cn_target_config_node_list", CONF.getTargetConfigNode().getIp() + ":" + CONF.getTargetConfigNode().getPort(), CONF.getInternalAddress() + ":" + CONF.getInternalPort(), "the config_node_consensus_protocol_class is set toorg.apache.iotdb.consensus.simple.SimpleConsensus");
        }
        if (CONF.getSchemaReplicationFactor() <= 0) {
            throw new ConfigurationException("The schema_replication_factor should be positive");
        }
        if (CONF.getDataReplicationFactor() <= 0) {
            throw new ConfigurationException("The data_replication_factor should be positive");
        }
        if (CONF.getSchemaReplicationFactor() > 1 && "org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getSchemaRegionConsensusProtocolClass())) {
            throw new ConfigurationException("schema_region_consensus_protocol_class", CONF.getSchemaRegionConsensusProtocolClass(), "org.apache.iotdb.consensus.ratis.RatisConsensus", "org.apache.iotdb.consensus.simple.SimpleConsensusavailable only when schema_replication_factor is set to 1");
        }
        if (CONF.getDataReplicationFactor() > 1 && "org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getDataRegionConsensusProtocolClass())) {
            throw new ConfigurationException("data_region_consensus_protocol_class", CONF.getDataRegionConsensusProtocolClass(), "org.apache.iotdb.consensus.iot.IoTConsensusororg.apache.iotdb.consensus.ratis.RatisConsensus", "org.apache.iotdb.consensus.simple.SimpleConsensusavailable only when data_replication_factor is set to 1");
        }
        if (CONF.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
            throw new ConfigurationException("schema_region_consensus_protocol_class", String.valueOf(CONF.getSchemaRegionConsensusProtocolClass()), String.format("%s or %s", "org.apache.iotdb.consensus.simple.SimpleConsensus", "org.apache.iotdb.consensus.ratis.RatisConsensus"), "the SchemaRegion doesn't support org.apache.iotdb.consensus.iot.IoTConsensus");
        }
        if (!"GREEDY".equals(CONF.getLeaderDistributionPolicy()) && !"MIN_COST_FLOW".equals(CONF.getLeaderDistributionPolicy())) {
            throw new ConfigurationException("leader_distribution_policy", CONF.getRoutePriorityPolicy(), "GREEDY or MIN_COST_FLOW", "an unrecognized leader_distribution_policy is set");
        }
        if (!CONF.getRoutePriorityPolicy().equals("LEADER") && !CONF.getRoutePriorityPolicy().equals("GREEDY")) {
            throw new ConfigurationException("route_priority_policy", CONF.getRoutePriorityPolicy(), "LEADER or GREEDY", "an unrecognized route_priority_policy is set");
        }
        if (CONF.getDefaultSchemaRegionGroupNumPerDatabase() <= 0) {
            throw new ConfigurationException("The default_schema_region_group_num should be positive");
        }
        if (CONF.getDefaultDataRegionGroupNumPerDatabase() <= 0) {
            throw new ConfigurationException("The default_data_region_group_num should be positive");
        }
        if (COMMON_CONFIG.getTimePartitionInterval() <= 0L) {
            throw new ConfigurationException("The time_partition_interval should be positive");
        }
        String timestampPrecision = COMMON_CONFIG.getTimestampPrecision();
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            throw new ConfigurationException("The timestamp_precision should be ms, us or ns");
        }
    }

    private void createDirsIfNecessary() throws IOException {
        File systemDir = new File(CONF.getSystemDir());
        this.createDirIfEmpty(systemDir);
        File consensusDir = new File(CONF.getConsensusDir());
        this.createDirIfEmpty(consensusDir);
    }

    private void createDirIfEmpty(File dir) throws IOException {
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                LOGGER.info("Make dirs: {}", (Object)dir);
            } else {
                throw new IOException(String.format("Start ConfigNode failed, because couldn't make system dirs: %s.", dir.getAbsolutePath()));
            }
        }
    }
}

