/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CountTimeSlotListPlan
extends ConfigPhysicalPlan {
    private String database;
    private TSeriesPartitionSlot seriesSlotId;
    private TConsensusGroupId regionId;
    private long startTime;
    private long endTime;

    public CountTimeSlotListPlan() {
        super(ConfigPhysicalPlanType.CountTimeSlotList);
    }

    public CountTimeSlotListPlan(long startTime, long endTime) {
        this();
        this.startTime = startTime;
        this.endTime = endTime;
        this.database = "";
        this.seriesSlotId = new TSeriesPartitionSlot(-1);
        this.regionId = new TConsensusGroupId(TConsensusGroupType.DataRegion, -1);
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setRegionId(TConsensusGroupId regionId) {
        this.regionId = regionId;
    }

    public TConsensusGroupId getRegionId() {
        return this.regionId;
    }

    public void setSeriesSlotId(TSeriesPartitionSlot seriesSlotId) {
        this.seriesSlotId = seriesSlotId;
    }

    public TSeriesPartitionSlot getSeriesSlotId() {
        return this.seriesSlotId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTSeriesPartitionSlot((TSeriesPartitionSlot)this.seriesSlotId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
        stream.writeLong(this.startTime);
        stream.writeLong(this.endTime);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.seriesSlotId = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot((ByteBuffer)buffer);
        this.regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer);
        this.startTime = buffer.getLong();
        this.endTime = buffer.getLong();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountTimeSlotListPlan that = (CountTimeSlotListPlan)o;
        return this.database.equals(that.database) && this.seriesSlotId.equals(that.seriesSlotId) && this.regionId.equals(that.regionId) && this.startTime == that.startTime && this.endTime == that.endTime;
    }

    @Override
    public int hashCode() {
        int hashcode = 1;
        hashcode = hashcode * 31 + Objects.hash(this.database);
        hashcode = hashcode * 31 + this.seriesSlotId.hashCode();
        hashcode = hashcode * 31 + this.regionId.hashCode();
        hashcode = hashcode * 31 + (int)this.startTime;
        hashcode = hashcode * 31 + (int)this.endTime;
        return hashcode;
    }
}

