/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.template;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GetTemplateSetInfoPlan
extends ConfigPhysicalPlan {
    private List<PartialPath> patternList;

    public GetTemplateSetInfoPlan() {
        super(ConfigPhysicalPlanType.GetTemplateSetInfo);
    }

    public GetTemplateSetInfoPlan(List<PartialPath> patternList) {
        super(ConfigPhysicalPlanType.GetTemplateSetInfo);
        this.patternList = patternList;
    }

    public List<PartialPath> getPatternList() {
        return this.patternList;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.getType().getPlanType(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.patternList.size(), (OutputStream)stream);
        for (PartialPath pattern : this.patternList) {
            pattern.serialize((OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.patternList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            this.patternList.add((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer));
        }
    }
}

