/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DropModelPlan
extends ConfigPhysicalPlan {
    private String modelId;

    public DropModelPlan() {
        super(ConfigPhysicalPlanType.DropModel);
    }

    public DropModelPlan(String modelId) {
        super(ConfigPhysicalPlanType.DropModel);
        Validate.notNull((Object)modelId);
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DropModelPlan that = (DropModelPlan)o;
        return this.modelId.equals(that.modelId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId);
    }
}

