/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.slf4j.Logger;

public class CreateRegionGroupsPlan
extends ConfigPhysicalPlan {
    protected final Map<String, List<TRegionReplicaSet>> regionGroupMap = new HashMap<String, List<TRegionReplicaSet>>();

    public CreateRegionGroupsPlan() {
        super(ConfigPhysicalPlanType.CreateRegionGroups);
    }

    public CreateRegionGroupsPlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    public Map<String, List<TRegionReplicaSet>> getRegionGroupMap() {
        return this.regionGroupMap;
    }

    public void addRegionGroup(String storageGroup, TRegionReplicaSet regionReplicaSet) {
        this.regionGroupMap.computeIfAbsent(storageGroup, regionReplicaSets -> new ArrayList()).add(regionReplicaSet);
    }

    public void planLog(Logger logger) {
        for (Map.Entry<String, List<TRegionReplicaSet>> regionGroupEntry : this.regionGroupMap.entrySet()) {
            String storageGroup = regionGroupEntry.getKey();
            for (TRegionReplicaSet regionReplicaSet : regionGroupEntry.getValue()) {
                logger.info("[CreateRegionGroups] RegionGroup: {}, belonged StorageGroup: {}, on DataNodes: {}", new Object[]{regionReplicaSet.getRegionId(), storageGroup, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList())});
            }
        }
    }

    public void serializeForProcedure(DataOutputStream stream) throws IOException {
        this.serializeImpl(stream);
    }

    public void deserializeForProcedure(ByteBuffer buffer) throws IOException {
        buffer.getShort();
        this.deserializeImpl(buffer);
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.regionGroupMap.size());
        for (Map.Entry<String, List<TRegionReplicaSet>> entry : this.regionGroupMap.entrySet()) {
            String storageGroup = entry.getKey();
            List<TRegionReplicaSet> regionReplicaSets = entry.getValue();
            BasicStructureSerDeUtil.write((String)storageGroup, (DataOutputStream)stream);
            stream.writeInt(regionReplicaSets.size());
            regionReplicaSets.forEach(regionReplicaSet -> ThriftCommonsSerDeUtils.serializeTRegionReplicaSet((TRegionReplicaSet)regionReplicaSet, (DataOutputStream)stream));
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            this.regionGroupMap.put(storageGroup, new ArrayList());
            int regionReplicaSetNum = buffer.getInt();
            for (int j = 0; j < regionReplicaSetNum; ++j) {
                TRegionReplicaSet regionReplicaSet = ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)buffer);
                this.regionGroupMap.get(storageGroup).add(regionReplicaSet);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRegionGroupsPlan that = (CreateRegionGroupsPlan)o;
        return this.regionGroupMap.equals(that.regionGroupMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regionGroupMap);
    }
}

