/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTransferringTriggersPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggersOnTransferNodesPlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TransferringTriggersResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TriggerLocationResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TriggerTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTriggerLocationReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.trigger.api.enums.TriggerType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerManager.class);
    private final ConfigManager configManager;
    private final TriggerInfo triggerInfo;

    public TriggerManager(ConfigManager configManager, TriggerInfo triggerInfo) {
        this.configManager = configManager;
        this.triggerInfo = triggerInfo;
    }

    public TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    public TSStatus createTrigger(TCreateTriggerReq req) {
        boolean isStateful = TriggerType.construct((byte)req.getTriggerType()) == TriggerType.STATEFUL;
        TDataNodeLocation dataNodeLocation = null;
        if (isStateful) {
            Optional<TDataNodeLocation> targetDataNode = this.configManager.getNodeManager().getLowestLoadDataNode();
            if (targetDataNode.isPresent()) {
                dataNodeLocation = targetDataNode.get();
            } else {
                return new TSStatus(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
            }
        }
        String triggerName = req.getTriggerName();
        boolean isUsingURI = req.isIsUsingURI();
        boolean needToSaveJar = isUsingURI && this.triggerInfo.needToSaveJar(triggerName);
        TriggerInformation triggerInformation = new TriggerInformation((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)req.pathPattern), triggerName, req.getClassName(), isUsingURI, req.getJarName(), req.getAttributes(), TriggerEvent.construct((byte)req.triggerEvent), TTriggerState.INACTIVE, isStateful, dataNodeLocation, FailureStrategy.construct((int)req.getFailureStrategy()), req.getJarMD5());
        return this.configManager.getProcedureManager().createTrigger(triggerInformation, needToSaveJar ? new Binary(req.getJarFile()) : null);
    }

    public TSStatus dropTrigger(TDropTriggerReq req) {
        return this.configManager.getProcedureManager().dropTrigger(req.getTriggerName());
    }

    public TGetTriggerTableResp getTriggerTable(boolean onlyStateful) {
        try {
            return ((TriggerTableResp)this.configManager.getConsensusManager().read(new GetTriggerTablePlan(onlyStateful)).getDataset()).convertToThriftResponse();
        }
        catch (IOException e) {
            LOGGER.error("Fail to get TriggerTable", (Throwable)e);
            return new TGetTriggerTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) {
        return ((TriggerLocationResp)this.configManager.getConsensusManager().read(new GetTriggerLocationPlan(triggerName)).getDataset()).convertToThriftResponse();
    }

    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) {
        return ((JarResp)this.configManager.getConsensusManager().read(new GetTriggerJarPlan(req.getJarNameList())).getDataset()).convertToThriftResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus transferTrigger(List<TDataNodeLocation> newUnknownDataNodeList, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        this.triggerInfo.acquireTriggerTableLock();
        try {
            ConsensusManager consensusManager = this.configManager.getConsensusManager();
            NodeManager nodeManager = this.configManager.getNodeManager();
            TSStatus transferResult = consensusManager.write(new UpdateTriggersOnTransferNodesPlan(newUnknownDataNodeList)).getStatus();
            if (transferResult.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = transferResult;
                return tSStatus;
            }
            List<String> transferringTriggers = ((TransferringTriggersResp)consensusManager.read(new GetTransferringTriggersPlan()).getDataset()).getTransferringTriggers();
            for (String trigger : transferringTriggers) {
                TDataNodeLocation newDataNodeLocation;
                transferResult = RpcUtils.squashResponseStatusList(this.updateTriggerLocation(trigger, newDataNodeLocation = nodeManager.getLowestLoadDataNode(dataNodeLocationMap.keySet()), dataNodeLocationMap));
                if (transferResult.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    TSStatus tSStatus = transferResult;
                    return tSStatus;
                }
                transferResult = consensusManager.write(new UpdateTriggerLocationPlan(trigger, newDataNodeLocation)).getStatus();
                if (transferResult.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                TSStatus tSStatus = transferResult;
                return tSStatus;
            }
        }
        finally {
            this.triggerInfo.releaseTriggerTableLock();
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public List<TSStatus> updateTriggerLocation(String triggerName, TDataNodeLocation dataNodeLocation, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        TUpdateTriggerLocationReq request = new TUpdateTriggerLocationReq(triggerName, dataNodeLocation);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TRIGGER_LOCATION, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }
}

