/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;

public abstract class BaseNodeCache {
    public static final int HEARTBEAT_TIMEOUT_TIME = 20000;
    public static final int MAXIMUM_WINDOW_SIZE = 100;
    protected final int nodeId;
    protected final LinkedList<NodeHeartbeatSample> slidingWindow = new LinkedList();
    protected AtomicReference<NodeStatistics> previousStatistics;
    protected AtomicReference<NodeStatistics> currentStatistics;

    protected BaseNodeCache(int nodeId) {
        this.nodeId = nodeId;
        this.previousStatistics = new AtomicReference<NodeStatistics>(NodeStatistics.generateDefaultNodeStatistics());
        this.currentStatistics = new AtomicReference<NodeStatistics>(NodeStatistics.generateDefaultNodeStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheHeartbeatSample(NodeHeartbeatSample newHeartbeatSample) {
        LinkedList<NodeHeartbeatSample> linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.isEmpty() || this.slidingWindow.getLast().getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.removeFirst();
            }
        }
    }

    public boolean periodicUpdate() {
        this.updateCurrentStatistics();
        if (!this.currentStatistics.get().equals(this.previousStatistics.get())) {
            this.previousStatistics.set(this.currentStatistics.get());
            return true;
        }
        return false;
    }

    public void forceUpdate(NodeHeartbeatSample newHeartbeatSample) {
        this.cacheHeartbeatSample(newHeartbeatSample);
        this.updateCurrentStatistics();
    }

    protected abstract void updateCurrentStatistics();

    public int getNodeId() {
        return this.nodeId;
    }

    public long getLoadScore() {
        return this.currentStatistics.get().getLoadScore();
    }

    public NodeStatus getNodeStatus() {
        return NodeStatus.parse((String)this.currentStatistics.get().getStatus().getStatus());
    }

    public String getNodeStatusWithReason() {
        NodeStatistics statistics = this.currentStatistics.get();
        return statistics.getStatusReason() == null ? statistics.getStatus().getStatus() : statistics.getStatus().getStatus() + "(" + statistics.getStatusReason() + ")";
    }

    public NodeStatistics getStatistics() {
        return this.currentStatistics.get();
    }

    public NodeStatistics getPreviousStatistics() {
        return this.previousStatistics.get();
    }
}

