/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.task;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.read.pipe.task.ShowPipePlanV2;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskCoordinator.class);
    private final ConfigManager configManager;
    private final PipeTaskInfo pipeTaskInfo;
    private final ReentrantLock pipeTaskCoordinatorLock;
    private AtomicReference<PipeTaskInfo> pipeTaskInfoHolder;

    public PipeTaskCoordinator(ConfigManager configManager, PipeTaskInfo pipeTaskInfo) {
        this.configManager = configManager;
        this.pipeTaskInfo = pipeTaskInfo;
        this.pipeTaskCoordinatorLock = new ReentrantLock(true);
    }

    public AtomicReference<PipeTaskInfo> lock() {
        this.pipeTaskCoordinatorLock.lock();
        LOGGER.info("Pipe task coordinator locked.");
        this.pipeTaskInfoHolder = new AtomicReference<PipeTaskInfo>(this.pipeTaskInfo);
        return this.pipeTaskInfoHolder;
    }

    public boolean unlock() {
        if (this.pipeTaskInfoHolder != null) {
            this.pipeTaskInfoHolder.set(null);
            this.pipeTaskInfoHolder = null;
        }
        try {
            this.pipeTaskCoordinatorLock.unlock();
            LOGGER.info("Pipe task coordinator unlocked.");
            return true;
        }
        catch (IllegalMonitorStateException ignored) {
            LOGGER.warn("This thread is not holding the lock.");
            return false;
        }
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        return this.configManager.getProcedureManager().createPipe(req);
    }

    public TSStatus startPipe(String pipeName) {
        boolean hasException = this.pipeTaskInfo.hasExceptions(pipeName);
        TSStatus status = this.configManager.getProcedureManager().startPipe(pipeName);
        if (status == RpcUtils.SUCCESS_STATUS && hasException) {
            LOGGER.info("Pipe {} has started successfully, clear its exceptions.", (Object)pipeName);
            this.configManager.getProcedureManager().pipeHandleMetaChange(true, true);
        }
        return status;
    }

    public TSStatus stopPipe(String pipeName) {
        boolean isStoppedByRuntimeException = this.pipeTaskInfo.isStoppedByRuntimeException(pipeName);
        TSStatus status = this.configManager.getProcedureManager().stopPipe(pipeName);
        if (status == RpcUtils.SUCCESS_STATUS && isStoppedByRuntimeException) {
            LOGGER.info("Pipe {} has stopped successfully manually, stop its auto restart process.", (Object)pipeName);
            this.pipeTaskInfo.setIsStoppedByRuntimeExceptionToFalse(pipeName);
            this.configManager.getProcedureManager().pipeHandleMetaChange(true, true);
        }
        return status;
    }

    public TSStatus dropPipe(String pipeName) {
        boolean isPipeExistedBeforeDrop = this.pipeTaskInfo.isPipeExisted(pipeName);
        TSStatus status = this.configManager.getProcedureManager().dropPipe(pipeName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to drop pipe {}. Result status: {}.", (Object)pipeName, (Object)status);
        }
        return isPipeExistedBeforeDrop ? status : RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_NOT_EXIST_ERROR, (String)String.format("Failed to drop pipe %s. Failures: %s does not exist.", pipeName, pipeName));
    }

    public TShowPipeResp showPipes(TShowPipeReq req) {
        this.lock();
        try {
            TShowPipeResp tShowPipeResp = ((PipeTableResp)this.configManager.getConsensusManager().read(new ShowPipePlanV2()).getDataset()).filter(req.whereClause, req.pipeName).convertToTShowPipeResp();
            return tShowPipeResp;
        }
        finally {
            this.unlock();
        }
    }

    public TGetAllPipeInfoResp getAllPipeInfo() {
        this.lock();
        try {
            TGetAllPipeInfoResp tGetAllPipeInfoResp = ((PipeTableResp)this.configManager.getConsensusManager().read(new ShowPipePlanV2()).getDataset()).convertToTGetAllPipeInfoResp();
            return tGetAllPipeInfoResp;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to get all pipe info.", (Throwable)e);
            TGetAllPipeInfoResp tGetAllPipeInfoResp = new TGetAllPipeInfoResp(new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
            return tGetAllPipeInfoResp;
        }
        finally {
            this.unlock();
        }
    }

    public boolean hasAnyPipe() {
        this.lock();
        try {
            boolean bl = !this.pipeTaskInfo.isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }
}

