/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.model.ModelTable;
import org.apache.iotdb.commons.model.TrailInformation;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.read.model.ShowModelPlan;
import org.apache.iotdb.confignode.consensus.request.read.model.ShowTrailPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.CreateModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.DropModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelStatePlan;
import org.apache.iotdb.confignode.consensus.response.ModelTableResp;
import org.apache.iotdb.confignode.consensus.response.TrailTableResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ModelInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelInfo.class);
    private static final String SNAPSHOT_FILENAME = "model_info.snapshot";
    private ModelTable modelTable;
    private final ReentrantLock modelTableLock = new ReentrantLock();

    public ModelInfo() {
        this.modelTable = new ModelTable();
    }

    public void acquireModelTableLock() {
        LOGGER.info("acquire ModelTableLock");
        this.modelTableLock.lock();
    }

    public void releaseModelTableLock() {
        LOGGER.info("release ModelTableLock");
        this.modelTableLock.unlock();
    }

    public TSStatus createModel(CreateModelPlan plan) {
        try {
            ModelInformation modelInformation = plan.getModelInformation();
            this.modelTable.addModel(modelInformation);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to add model [%s] in ModelTable on Config Nodes, because of %s", plan.getModelInformation().getModelId(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus dropModel(DropModelPlan plan) {
        String modelId = plan.getModelId();
        if (this.modelTable.containsModel(modelId)) {
            this.modelTable.removeModel(modelId);
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelTableResp showModel(ShowModelPlan plan) {
        this.acquireModelTableLock();
        try {
            ModelTableResp modelTableResp = new ModelTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            if (plan.isSetModelId()) {
                ModelInformation modelInformation = this.modelTable.getModelInformationById(plan.getModelId());
                if (modelInformation != null) {
                    modelTableResp.addModelInformation(modelInformation);
                }
            } else {
                modelTableResp.addModelInformation(this.modelTable.getAllModelInformation());
            }
            ModelTableResp modelTableResp2 = modelTableResp;
            return modelTableResp2;
        }
        catch (IOException e) {
            LOGGER.warn("Fail to get ModelTable", (Throwable)e);
            ModelTableResp modelTableResp = new ModelTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()));
            return modelTableResp;
        }
        finally {
            this.releaseModelTableLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrailTableResp showTrail(ShowTrailPlan plan) {
        this.acquireModelTableLock();
        try {
            String modelId = plan.getModelId();
            ModelInformation modelInformation = this.modelTable.getModelInformationById(modelId);
            if (modelInformation == null) {
                TrailTableResp trailTableResp = new TrailTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(String.format("Failed to show trails of model [%s], this model has not been created.", modelId)));
                return trailTableResp;
            }
            TrailTableResp trailTableResp = new TrailTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            if (plan.isSetTrailId()) {
                TrailInformation trailInformation = modelInformation.getTrailInformationById(plan.getTrailId());
                if (trailInformation != null) {
                    trailTableResp.addTrailInformation(trailInformation);
                }
            } else {
                trailTableResp.addTrailInformation(modelInformation.getAllTrailInformation());
            }
            TrailTableResp trailTableResp2 = trailTableResp;
            return trailTableResp2;
        }
        catch (IOException e) {
            LOGGER.warn("Fail to get TrailTable", (Throwable)e);
            TrailTableResp trailTableResp = new TrailTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()));
            return trailTableResp;
        }
        finally {
            this.releaseModelTableLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus updateModelInfo(UpdateModelInfoPlan plan) {
        this.acquireModelTableLock();
        try {
            String modelId = plan.getModelId();
            if (this.modelTable.containsModel(modelId)) {
                this.modelTable.updateModel(modelId, plan.getTrailId(), plan.getModelInfo());
            }
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseModelTableLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus updateModelState(UpdateModelStatePlan plan) {
        this.acquireModelTableLock();
        try {
            String modelId = plan.getModelId();
            if (this.modelTable.containsModel(modelId)) {
                this.modelTable.updateState(modelId, plan.getState(), plan.getBestTrailId());
            }
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseModelTableLock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot of ModelInfo, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        this.acquireModelTableLock();
        try {
            boolean bl;
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.modelTable.serialize(fileOutputStream);
                bl = true;
            }
            return bl;
        }
        finally {
            this.releaseModelTableLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot of ModelInfo, snapshot file [{}] does not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.acquireModelTableLock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.modelTable.clear();
            this.modelTable = ModelTable.deserialize((InputStream)fileInputStream);
        }
        finally {
            this.releaseModelTableLock();
        }
    }

    public boolean isModelExist(String modelId) {
        return this.modelTable.containsModel(modelId);
    }
}

