/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.node;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateVersionInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeInfo.class);
    private static final int MINIMUM_DATANODE = Math.max(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor(), ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
    private final ReentrantReadWriteLock configNodeInfoReadWriteLock;
    private final Map<Integer, TConfigNodeLocation> registeredConfigNodes;
    private final ReentrantReadWriteLock dataNodeInfoReadWriteLock;
    private final ReentrantReadWriteLock versionInfoReadWriteLock;
    private final AtomicInteger nextNodeId = new AtomicInteger(-1);
    private final Map<Integer, TDataNodeConfiguration> registeredDataNodes;
    private final Map<Integer, TNodeVersionInfo> nodeVersionInfo;
    private static final String SNAPSHOT_FILENAME = "node_info.bin";

    public NodeInfo() {
        this.configNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.registeredConfigNodes = new ConcurrentHashMap<Integer, TConfigNodeLocation>();
        this.dataNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.registeredDataNodes = new ConcurrentHashMap<Integer, TDataNodeConfiguration>();
        this.nodeVersionInfo = new ConcurrentHashMap<Integer, TNodeVersionInfo>();
        this.versionInfoReadWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus registerDataNode(RegisterDataNodePlan registerDataNodePlan) {
        TSStatus result;
        TDataNodeConfiguration info = registerDataNodePlan.getDataNodeConfiguration();
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        try {
            AtomicInteger atomicInteger = this.nextNodeId;
            synchronized (atomicInteger) {
                if (this.nextNodeId.get() < info.getLocation().getDataNodeId()) {
                    this.nextNodeId.set(info.getLocation().getDataNodeId());
                }
            }
            this.registeredDataNodes.put(info.getLocation().getDataNodeId(), info);
            result = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            if (this.nextNodeId.get() < MINIMUM_DATANODE) {
                result.setMessage(String.format("To enable IoTDB-Cluster's data service, please register %d more IoTDB-DataNode", MINIMUM_DATANODE - this.nextNodeId.get()));
            } else if (this.nextNodeId.get() == MINIMUM_DATANODE) {
                result.setMessage("IoTDB-Cluster could provide data service, now enjoy yourself!");
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    public TSStatus removeDataNode(RemoveDataNodePlan req) {
        LOGGER.info("{}, There are {} data node in cluster before executed RemoveDataNodePlan", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)this.registeredDataNodes.size());
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        this.versionInfoReadWriteLock.writeLock().lock();
        try {
            req.getDataNodeLocations().forEach(removeDataNodes -> {
                this.registeredDataNodes.remove(removeDataNodes.getDataNodeId());
                this.nodeVersionInfo.remove(removeDataNodes.getDataNodeId());
                LOGGER.info("Removed the datanode {} from cluster", removeDataNodes);
            });
        }
        finally {
            this.versionInfoReadWriteLock.writeLock().unlock();
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
        LOGGER.info("{}, There are {} data node in cluster after executed RemoveDataNodePlan", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)this.registeredDataNodes.size());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus updateDataNode(UpdateDataNodePlan updateDataNodePlan) {
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        try {
            TDataNodeConfiguration newConfiguration = updateDataNodePlan.getDataNodeConfiguration();
            this.registeredDataNodes.replace(newConfiguration.getLocation().getDataNodeId(), newConfiguration);
        }
        finally {
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNodeConfigurationResp getDataNodeConfiguration(GetDataNodeConfigurationPlan getDataNodeConfigurationPlan) {
        DataNodeConfigurationResp result = new DataNodeConfigurationResp();
        result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        int dataNodeId = getDataNodeConfigurationPlan.getDataNodeId();
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            if (dataNodeId == -1) {
                result.setDataNodeConfigurationMap(new HashMap<Integer, TDataNodeConfiguration>(this.registeredDataNodes));
            } else {
                result.setDataNodeConfigurationMap(this.registeredDataNodes.get(dataNodeId) == null ? new HashMap<Integer, TDataNodeConfiguration>(0) : Collections.singletonMap(dataNodeId, this.registeredDataNodes.get(dataNodeId)));
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int getRegisteredDataNodeCount() {
        int result;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = this.registeredDataNodes.size();
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCpuCoreCount() {
        int result = 0;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            for (TDataNodeConfiguration dataNodeConfiguration : this.registeredDataNodes.values()) {
                result += dataNodeConfiguration.getResource().getCpuCoreNum();
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public List<TDataNodeConfiguration> getRegisteredDataNodes() {
        ArrayList<TDataNodeConfiguration> result;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TDataNodeConfiguration>(this.registeredDataNodes.values());
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public TDataNodeConfiguration getRegisteredDataNode(int dataNodeId) {
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            TDataNodeConfiguration tDataNodeConfiguration = this.registeredDataNodes.getOrDefault(dataNodeId, new TDataNodeConfiguration()).deepCopy();
            return tDataNodeConfiguration;
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
    }

    public List<TDataNodeConfiguration> getRegisteredDataNodes(List<Integer> dataNodeIds) {
        ArrayList<TDataNodeConfiguration> result = new ArrayList<TDataNodeConfiguration>();
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            dataNodeIds.forEach(dataNodeId -> {
                if (this.registeredDataNodes.containsKey(dataNodeId)) {
                    result.add(this.registeredDataNodes.get(dataNodeId).deepCopy());
                }
            });
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus applyConfigNode(ApplyConfigNodePlan applyConfigNodePlan) {
        TSStatus status = new TSStatus();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            AtomicInteger atomicInteger = this.nextNodeId;
            synchronized (atomicInteger) {
                if (this.nextNodeId.get() < applyConfigNodePlan.getConfigNodeLocation().getConfigNodeId()) {
                    this.nextNodeId.set(applyConfigNodePlan.getConfigNodeLocation().getConfigNodeId());
                }
            }
            this.registeredConfigNodes.put(applyConfigNodePlan.getConfigNodeLocation().getConfigNodeId(), applyConfigNodePlan.getConfigNodeLocation());
            SystemPropertiesUtils.storeConfigNodeList(new ArrayList<TConfigNodeLocation>(this.registeredConfigNodes.values()));
            LOGGER.info("Successfully apply ConfigNode: {}. Current ConfigNodeGroup: {}", (Object)applyConfigNodePlan.getConfigNodeLocation(), this.registeredConfigNodes);
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (IOException e) {
            LOGGER.error("Update online ConfigNode failed.", (Throwable)e);
            status.setCode(TSStatusCode.ADD_CONFIGNODE_ERROR.getStatusCode());
            status.setMessage("Apply new ConfigNode failed because current ConfigNode can't store ConfigNode information.");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        TSStatus status = new TSStatus();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        this.versionInfoReadWriteLock.writeLock().lock();
        try {
            this.registeredConfigNodes.remove(removeConfigNodePlan.getConfigNodeLocation().getConfigNodeId());
            this.nodeVersionInfo.remove(removeConfigNodePlan.getConfigNodeLocation().getConfigNodeId());
            SystemPropertiesUtils.storeConfigNodeList(new ArrayList<TConfigNodeLocation>(this.registeredConfigNodes.values()));
            LOGGER.info("Successfully remove ConfigNode: {}. Current ConfigNodeGroup: {}", (Object)removeConfigNodePlan.getConfigNodeLocation(), this.registeredConfigNodes);
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (IOException e) {
            LOGGER.error("Remove online ConfigNode failed.", (Throwable)e);
            status.setCode(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode());
            status.setMessage("Remove ConfigNode failed because current ConfigNode can't store ConfigNode information.");
        }
        finally {
            this.versionInfoReadWriteLock.writeLock().unlock();
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return status;
    }

    public TSStatus updateVersionInfo(UpdateVersionInfoPlan updateVersionInfoPlan) {
        this.versionInfoReadWriteLock.writeLock().lock();
        try {
            this.nodeVersionInfo.put(updateVersionInfoPlan.getNodeId(), updateVersionInfoPlan.getVersionInfo());
        }
        finally {
            this.versionInfoReadWriteLock.writeLock().unlock();
        }
        LOGGER.info("Successfully update Node {} 's version.", (Object)updateVersionInfoPlan.getNodeId());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public List<TConfigNodeLocation> getRegisteredConfigNodes() {
        ArrayList<TConfigNodeLocation> result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TConfigNodeLocation>(this.registeredConfigNodes.values());
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public List<TConfigNodeLocation> getRegisteredConfigNodes(List<Integer> configNodeIds) {
        ArrayList<TConfigNodeLocation> result = new ArrayList<TConfigNodeLocation>();
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            configNodeIds.forEach(configNodeId -> {
                if (this.registeredConfigNodes.containsKey(configNodeId)) {
                    result.add(this.registeredConfigNodes.get(configNodeId).deepCopy());
                }
            });
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public Map<Integer, TNodeVersionInfo> getNodeVersionInfo() {
        HashMap<Integer, TNodeVersionInfo> result = new HashMap<Integer, TNodeVersionInfo>(this.nodeVersionInfo.size());
        this.versionInfoReadWriteLock.readLock().lock();
        try {
            result.putAll(this.nodeVersionInfo);
        }
        finally {
            this.versionInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public TNodeVersionInfo getVersionInfo(int nodeId) {
        this.versionInfoReadWriteLock.readLock().lock();
        try {
            TNodeVersionInfo tNodeVersionInfo = this.nodeVersionInfo.getOrDefault(nodeId, new TNodeVersionInfo("Unknown", "Unknown"));
            return tNodeVersionInfo;
        }
        finally {
            this.versionInfoReadWriteLock.readLock().unlock();
        }
    }

    public int generateNextNodeId() {
        return this.nextNodeId.incrementAndGet();
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException, TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void serializeRegisteredConfigNode(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.registeredConfigNodes.size(), (OutputStream)outputStream);
        for (Map.Entry<Integer, TConfigNodeLocation> entry : this.registeredConfigNodes.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)outputStream);
            entry.getValue().write(protocol);
        }
    }

    private void serializeRegisteredDataNode(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.registeredDataNodes.size(), (OutputStream)outputStream);
        for (Map.Entry<Integer, TDataNodeConfiguration> entry : this.registeredDataNodes.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)outputStream);
            entry.getValue().write(protocol);
        }
    }

    private void serializeVersionInfo(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.nodeVersionInfo.size(), (OutputStream)outputStream);
        for (Map.Entry<Integer, TNodeVersionInfo> entry : this.nodeVersionInfo.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)entry.getValue().getVersion(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)entry.getValue().getBuildInfo(), (OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException, TException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.configNodeInfoReadWriteLock.writeLock().lock();
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        this.versionInfoReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             TIOStreamTransport tioStreamTransport = new TIOStreamTransport((InputStream)fileInputStream);){
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tioStreamTransport);
            this.clear();
            this.nextNodeId.set(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
            this.deserializeRegisteredConfigNode(fileInputStream, (TProtocol)protocol);
            this.deserializeRegisteredDataNode(fileInputStream, (TProtocol)protocol);
            this.deserializeBuildInfo(fileInputStream);
        }
        finally {
            this.versionInfoReadWriteLock.writeLock().unlock();
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
    }

    private void deserializeRegisteredConfigNode(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            int configNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            TConfigNodeLocation configNodeLocation = new TConfigNodeLocation();
            configNodeLocation.read(protocol);
            this.registeredConfigNodes.put(configNodeId, configNodeLocation);
        }
    }

    private void deserializeRegisteredDataNode(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            int dataNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            TDataNodeConfiguration dataNodeInfo = new TDataNodeConfiguration();
            dataNodeInfo.read(protocol);
            this.registeredDataNodes.put(dataNodeId, dataNodeInfo);
        }
    }

    private void deserializeBuildInfo(InputStream inputStream) throws IOException {
        if (inputStream.available() != 0) {
            for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
                int nodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
                String version = ReadWriteIOUtils.readString((InputStream)inputStream);
                String buildInfo = ReadWriteIOUtils.readString((InputStream)inputStream);
                this.nodeVersionInfo.put(nodeId, new TNodeVersionInfo(version, buildInfo));
            }
        }
    }

    public static int getMinimumDataNode() {
        return MINIMUM_DATANODE;
    }

    public void clear() {
        this.nextNodeId.set(-1);
        this.registeredDataNodes.clear();
        this.registeredConfigNodes.clear();
        this.nodeVersionInfo.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        return this.registeredConfigNodes.equals(nodeInfo.registeredConfigNodes) && this.nextNodeId.get() == nodeInfo.nextNodeId.get() && this.registeredDataNodes.equals(nodeInfo.registeredDataNodes) && this.nodeVersionInfo.equals(nodeInfo.nodeVersionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.registeredConfigNodes, this.nextNodeId, this.registeredDataNodes, this.nodeVersionInfo);
    }
}

