/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.model.exception.ModelManagementException;
import org.apache.iotdb.confignode.consensus.request.write.model.CreateModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.DropModelPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.ModelInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.model.CreateModelState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.db.protocol.client.MLNodeClient;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateModelProcedure
extends AbstractNodeProcedure<CreateModelState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateModelProcedure.class);
    private static final int RETRY_THRESHOLD = 1;
    private ModelInformation modelInformation;
    private Map<String, String> modelConfigs;

    public CreateModelProcedure() {
    }

    public CreateModelProcedure(ModelInformation modelInformation, Map<String, String> modelConfigs) {
        this.modelInformation = modelInformation;
        this.modelConfigs = modelConfigs;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateModelState state) {
        block20: {
            if (this.modelInformation == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case INIT: {
                        LOGGER.info("Start to create model [{}]", (Object)this.modelInformation.getModelId());
                        ModelInfo modelInfo = env.getConfigManager().getModelManager().getModelInfo();
                        modelInfo.acquireModelTableLock();
                        String modelId = this.modelInformation.getModelId();
                        if (modelInfo.isModelExist(modelId)) {
                            throw new ModelManagementException(String.format("Failed to create model [%s], the same name model has been created", modelId));
                        }
                        this.setNextState(CreateModelState.VALIDATED);
                        break;
                    }
                    case VALIDATED: {
                        ConfigManager configManager = env.getConfigManager();
                        String modelId = this.modelInformation.getModelId();
                        LOGGER.info("Start to add model [{}] in ModelTable on Config Nodes", (Object)modelId);
                        ConsensusWriteResponse response = configManager.getConsensusManager().write(new CreateModelPlan(this.modelInformation));
                        if (!response.isSuccessful()) {
                            throw new ModelManagementException(String.format("Failed to add model [%s] in ModelTable on Config Nodes: %s", modelId, response.getErrorMessage()));
                        }
                        this.setNextState(CreateModelState.CONFIG_NODE_ACTIVE);
                        break;
                    }
                    case CONFIG_NODE_ACTIVE: {
                        LOGGER.info("Start to train model [{}] on ML Node", (Object)this.modelInformation.getModelId());
                        try (MLNodeClient client = new MLNodeClient();){
                            TSStatus status = client.createTrainingTask(this.modelInformation, this.modelConfigs);
                            if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                throw new TException(status.getMessage());
                            }
                            this.setNextState(CreateModelState.ML_NODE_ACTIVE);
                            break;
                        }
                        catch (TException e) {
                            throw new ModelManagementException(String.format("Fail to start training model [%s] on ML Node: %s", this.modelInformation.getModelId(), e.getMessage()));
                        }
                    }
                    case ML_NODE_ACTIVE: {
                        env.getConfigManager().getModelManager().getModelInfo().releaseModelTableLock();
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in CreateModelProcedure", (Throwable)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to create model [{}], state [{}]", new Object[]{this.modelInformation.getModelId(), state, e});
                if (this.getCycles() <= 1) break block20;
                this.setFailure(new ProcedureException(String.format("Fail to create model [%s] at STATE [%s]", new Object[]{this.modelInformation.getModelId(), state})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, CreateModelState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case INIT: {
                LOGGER.info("Start [INIT] rollback of model [{}]", (Object)this.modelInformation.getModelId());
                env.getConfigManager().getModelManager().getModelInfo().releaseModelTableLock();
                break;
            }
            case VALIDATED: {
                LOGGER.info("Start [VALIDATED] rollback of model [{}]", (Object)this.modelInformation.getModelId());
                env.getConfigManager().getConsensusManager().write(new DropModelPlan(this.modelInformation.getModelId()));
                break;
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(CreateModelState state) {
        return true;
    }

    @Override
    protected CreateModelState getState(int stateId) {
        return CreateModelState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateModelState createModelState) {
        return createModelState.ordinal();
    }

    @Override
    protected CreateModelState getInitialState() {
        return CreateModelState.INIT;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_MODEL_PROCEDURE.getTypeCode());
        super.serialize(stream);
        this.modelInformation.serialize(stream);
        ReadWriteIOUtils.write(this.modelConfigs, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.modelInformation = ModelInformation.deserialize((ByteBuffer)byteBuffer);
        this.modelConfigs = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof CreateModelProcedure) {
            CreateModelProcedure thatProc = (CreateModelProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.modelInformation.equals(this.modelInformation) && thatProc.modelConfigs.equals(this.modelConfigs);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.modelInformation, this.modelConfigs});
    }
}

