/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.pipe.task.OperatePipeTaskState;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperatePipeProcedureV2
extends AbstractNodeProcedure<OperatePipeTaskState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperatePipeProcedureV2.class);
    private static final int RETRY_THRESHOLD = 1;
    protected boolean isRollbackFromOperateOnDataNodesSuccessful = false;
    protected AtomicReference<PipeTaskInfo> pipeTaskInfo;

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            if (configNodeProcedureEnv.getNodeLock().tryLock(this)) {
                this.pipeTaskInfo = configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().lock();
                LOGGER.info("ProcedureId {} acquire lock.", (Object)this.getProcId());
                ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
                return procedureLockState;
            }
            configNodeProcedureEnv.getNodeLock().waitProcedure(this);
            LOGGER.info("ProcedureId {} wait for lock.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_EVENT_WAIT;
            return procedureLockState;
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOGGER.info("ProcedureId {} release lock.", (Object)this.getProcId());
            if (this.pipeTaskInfo != null) {
                configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
            }
            if (configNodeProcedureEnv.getNodeLock().releaseLock(this)) {
                configNodeProcedureEnv.getNodeLock().wakeWaitingProcedures(configNodeProcedureEnv.getScheduler());
            }
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    protected abstract PipeTaskOperation getOperation();

    protected abstract void executeFromValidateTask(ConfigNodeProcedureEnv var1) throws PipeException;

    protected abstract void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv var1);

    protected abstract void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv var1) throws PipeException;

    protected abstract void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws PipeException, IOException;

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, OperatePipeTaskState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        try {
            switch (state) {
                case VALIDATE_TASK: {
                    this.executeFromValidateTask(env);
                    this.setNextState(OperatePipeTaskState.CALCULATE_INFO_FOR_TASK);
                    break;
                }
                case CALCULATE_INFO_FOR_TASK: {
                    this.executeFromCalculateInfoForTask(env);
                    this.setNextState(OperatePipeTaskState.WRITE_CONFIG_NODE_CONSENSUS);
                    break;
                }
                case WRITE_CONFIG_NODE_CONSENSUS: {
                    this.executeFromWriteConfigNodeConsensus(env);
                    this.setNextState(OperatePipeTaskState.OPERATE_ON_DATA_NODES);
                    break;
                }
                case OPERATE_ON_DATA_NODES: {
                    this.executeFromOperateOnDataNodes(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown state during executing operatePipeProcedure, %s", new Object[]{state}));
                }
            }
        }
        catch (Exception e) {
            if (this.getCycles() < 1) {
                LOGGER.warn("Encountered error when trying to {} at state [{}], retry [{}/{}]", new Object[]{this.getOperation(), state, this.getCycles() + 1, 1, e});
                TimeUnit.MILLISECONDS.sleep(3000L);
            }
            LOGGER.warn("All {} retries failed when trying to {} at state [{}], will rollback...", new Object[]{1, this.getOperation(), state, e});
            this.setFailure(new ProcedureException(String.format("Fail to %s because %s", this.getOperation().name(), e.getMessage())));
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected boolean isRollbackSupported(OperatePipeTaskState state) {
        return true;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeTaskState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case VALIDATE_TASK: {
                this.rollbackFromValidateTask(env);
                break;
            }
            case CALCULATE_INFO_FOR_TASK: {
                this.rollbackFromCalculateInfoForTask(env);
                break;
            }
            case WRITE_CONFIG_NODE_CONSENSUS: {
                if (this.isRollbackFromOperateOnDataNodesSuccessful) break;
                this.rollbackFromWriteConfigNodeConsensus(env);
                break;
            }
            case OPERATE_ON_DATA_NODES: {
                this.rollbackFromWriteConfigNodeConsensus(env);
                this.rollbackFromOperateOnDataNodes(env);
                this.isRollbackFromOperateOnDataNodesSuccessful = true;
                break;
            }
            default: {
                LOGGER.error("Unsupported roll back STATE [{}]", (Object)state);
            }
        }
    }

    protected abstract void rollbackFromValidateTask(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv var1);

    protected abstract void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv var1) throws IOException;

    @Override
    protected OperatePipeTaskState getState(int stateId) {
        return OperatePipeTaskState.values()[stateId];
    }

    @Override
    protected int getStateId(OperatePipeTaskState state) {
        return state.ordinal();
    }

    @Override
    protected OperatePipeTaskState getInitialState() {
        return OperatePipeTaskState.VALIDATE_TASK;
    }

    protected Map<Integer, TPushPipeMetaResp> pushPipeMetaToDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        for (PipeMeta pipeMeta : this.pipeTaskInfo.get().getPipeMetaList()) {
            pipeMetaBinaryList.add(pipeMeta.serialize());
        }
        return env.pushPipeMetaToDataNodes(pipeMetaBinaryList);
    }

    protected String parsePushPipeMetaExceptionForPipe(String pipeName, Map<Integer, TPushPipeMetaResp> respMap) {
        StringBuilder exceptionMessageBuilder = new StringBuilder();
        for (Map.Entry<Integer, TPushPipeMetaResp> respEntry : respMap.entrySet()) {
            int dataNodeId = respEntry.getKey();
            TPushPipeMetaResp resp = respEntry.getValue();
            if (resp.getStatus().getCode() != TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode()) continue;
            if (!resp.isSetExceptionMessages()) {
                exceptionMessageBuilder.append(String.format("DataNodeId: %s, Message: Internal error while processing pushPipeMeta on dataNodes.", dataNodeId));
                continue;
            }
            AtomicBoolean hasException = new AtomicBoolean(false);
            resp.getExceptionMessages().forEach(message -> {
                if (pipeName == null) {
                    hasException.set(true);
                    exceptionMessageBuilder.append(String.format("PipeName: %s, Message: %s", message.getPipeName(), message.getMessage()));
                } else if (pipeName.equals(message.getPipeName())) {
                    hasException.set(true);
                    exceptionMessageBuilder.append(String.format("Message: %s", message.getMessage()));
                }
            });
            if (!hasException.get()) continue;
            exceptionMessageBuilder.insert(0, String.format("DataNodeId: %s, ", dataNodeId));
            exceptionMessageBuilder.append(". ");
        }
        return exceptionMessageBuilder.toString();
    }

    protected void pushPipeMetaToDataNodesIgnoreException(ConfigNodeProcedureEnv env) {
        try {
            this.pushPipeMetaToDataNodes(env);
        }
        catch (Exception e) {
            LOGGER.info("Failed to push pipe meta list to data nodes, will retry later.", (Throwable)e);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isRollbackFromOperateOnDataNodesSuccessful, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.isRollbackFromOperateOnDataNodesSuccessful = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }
}

