/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureWAL {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureWAL.class);
    private static final String TMP_SUFFIX = ".tmp";
    private static final int PROCEDURE_WAL_BUFFER_SIZE = 0x800000;
    private IProcedureFactory procedureFactory;
    private Path walFilePath;

    public ProcedureWAL(Path walFilePath, IProcedureFactory procedureFactory) {
        this.walFilePath = walFilePath;
        this.procedureFactory = procedureFactory;
    }

    public void save(Procedure procedure) throws IOException {
        File walTmp = new File(this.walFilePath + TMP_SUFFIX);
        Path walTmpPath = walTmp.toPath();
        Files.deleteIfExists(walTmpPath);
        Files.createFile(walTmpPath, new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(walTmp);
             FileChannel channel = fos.getChannel();
             PublicBAOS publicBAOS = new PublicBAOS();
             DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)publicBAOS);){
            procedure.serialize(dataOutputStream);
            channel.write(ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size()));
        }
        Files.deleteIfExists(this.walFilePath);
        Files.move(walTmpPath, this.walFilePath, new CopyOption[0]);
    }

    public void load(List<Procedure> procedureList) {
        block14: {
            Procedure procedure = null;
            try (FileInputStream fis = new FileInputStream(this.walFilePath.toFile());
                 FileChannel channel = fis.getChannel();){
                ByteBuffer byteBuffer = ByteBuffer.allocate(0x800000);
                if (channel.read(byteBuffer) > 0) {
                    byteBuffer.flip();
                    procedure = this.procedureFactory.create(byteBuffer);
                    byteBuffer.clear();
                }
                procedureList.add(procedure);
            }
            catch (IOException e) {
                LOG.error("Load {} failed, it will be deleted.", (Object)this.walFilePath, (Object)e);
                if (this.walFilePath.toFile().delete()) break block14;
                LOG.error("{} delete failed; take appropriate action.", (Object)this.walFilePath, (Object)e);
            }
        }
    }

    public void delete() {
        try {
            Files.deleteIfExists(Paths.get(this.walFilePath + TMP_SUFFIX, new String[0]));
            Files.deleteIfExists(this.walFilePath);
        }
        catch (IOException e) {
            LOG.error("Delete procedure wal failed.");
        }
    }
}

