/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.schemaregion.SchemaRegionStateMachine;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public class SchemaRegionConsensusImpl {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    private static IConsensus INSTANCE = null;

    private SchemaRegionConsensusImpl() {
    }

    public static IConsensus getInstance() {
        return INSTANCE;
    }

    public static synchronized IConsensus setupAndGetInstance() {
        if (INSTANCE == null) {
            INSTANCE = (IConsensus)ConsensusFactory.getConsensusImpl((String)conf.getSchemaRegionConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(conf.getDataNodeId()).setThisNode(new TEndPoint(conf.getInternalAddress(), conf.getSchemaRegionConsensusPort())).setConsensusGroupType(TConsensusGroupType.SchemaRegion).setRatisConfig(RatisConfig.newBuilder().setSnapshot(RatisConfig.Snapshot.newBuilder().setAutoTriggerThreshold(conf.getSchemaRatisConsensusSnapshotTriggerThreshold()).build()).setLog(RatisConfig.Log.newBuilder().setUnsafeFlushEnabled(conf.isSchemaRatisConsensusLogUnsafeFlushEnable()).setSegmentSizeMax(SizeInBytes.valueOf((long)conf.getSchemaRatisConsensusLogSegmentSizeMax())).setPreserveNumsWhenPurge(conf.getSchemaRatisConsensusPreserveWhenPurge()).build()).setGrpc(RatisConfig.Grpc.newBuilder().setFlowControlWindow(SizeInBytes.valueOf((long)conf.getSchemaRatisConsensusGrpcFlowControlWindow())).build()).setRpc(RatisConfig.Rpc.newBuilder().setTimeoutMin(TimeDuration.valueOf((long)conf.getSchemaRatisConsensusLeaderElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setTimeoutMax(TimeDuration.valueOf((long)conf.getSchemaRatisConsensusLeaderElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setRequestTimeout(TimeDuration.valueOf((long)conf.getSchemaRatisConsensusRequestTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMin(TimeDuration.valueOf((long)conf.getRatisFirstElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMax(TimeDuration.valueOf((long)conf.getRatisFirstElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).setClient(RatisConfig.Client.newBuilder().setClientRequestTimeoutMillis(conf.getDataRatisConsensusRequestTimeoutMs()).setClientMaxRetryAttempt(conf.getDataRatisConsensusMaxRetryAttempts()).setClientRetryInitialSleepTimeMs(conf.getDataRatisConsensusInitialSleepTimeMs()).setClientRetryMaxSleepTimeMs(conf.getDataRatisConsensusMaxSleepTimeMs()).setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build()).setImpl(RatisConfig.Impl.newBuilder().setTriggerSnapshotFileSize(conf.getSchemaRatisLogMax()).build()).setLeaderLogAppender(RatisConfig.LeaderLogAppender.newBuilder().setBufferByteLimit(conf.getSchemaRatisConsensusLogAppenderBufferSizeMax()).build()).setRead(RatisConfig.Read.newBuilder().setReadTimeout(TimeDuration.valueOf((long)conf.getConnectionTimeoutInMS(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).build()).setStorageDir(conf.getSchemaRegionConsensusDir()).build(), gid -> new SchemaRegionStateMachine(SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)gid))).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", conf.getSchemaRegionConsensusProtocolClass())));
        }
        return INSTANCE;
    }
}

