/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferFileSealReq
extends TPipeTransferReq {
    private String fileName;
    private long fileLength;

    private PipeTransferFileSealReq() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public static PipeTransferFileSealReq toTPipeTransferReq(String fileName, long fileLength) throws IOException {
        PipeTransferFileSealReq fileSealReq = new PipeTransferFileSealReq();
        fileSealReq.fileName = fileName;
        fileSealReq.fileLength = fileLength;
        fileSealReq.version = IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion();
        fileSealReq.type = PipeRequestType.TRANSFER_FILE_SEAL.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)fileLength, (OutputStream)outputStream);
            fileSealReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return fileSealReq;
    }

    public static PipeTransferFileSealReq fromTPipeTransferReq(TPipeTransferReq req) {
        PipeTransferFileSealReq fileSealReq = new PipeTransferFileSealReq();
        fileSealReq.fileName = ReadWriteIOUtils.readString((ByteBuffer)req.body);
        fileSealReq.fileLength = ReadWriteIOUtils.readLong((ByteBuffer)req.body);
        fileSealReq.version = req.version;
        fileSealReq.type = req.type;
        fileSealReq.body = req.body;
        return fileSealReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferFileSealReq that = (PipeTransferFileSealReq)((Object)obj);
        return this.fileName.equals(that.fileName) && this.fileLength == that.fileLength && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileLength, this.version, this.type, this.body);
    }
}

