/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.row;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.event.common.row.PipeBinaryTransformer;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class PipeRowCollector
implements RowCollector {
    private final List<TabletInsertionEvent> tabletInsertionEventList = new ArrayList<TabletInsertionEvent>();
    private Tablet tablet = null;
    private boolean isAligned = false;

    public void collectRow(Row row) {
        if (!(row instanceof PipeRow)) {
            throw new PipeException("Row can not be customized");
        }
        PipeRow pipeRow = (PipeRow)row;
        MeasurementSchema[] measurementSchemaArray = pipeRow.getMeasurementSchemaList();
        if (this.tablet == null) {
            String deviceId = pipeRow.getDeviceId();
            ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>(Arrays.asList(measurementSchemaArray));
            this.tablet = new Tablet(deviceId, measurementSchemaList, PipeConfig.getInstance().getPipeDataStructureTabletRowSize());
            this.isAligned = pipeRow.isAligned();
            this.tablet.initBitMaps();
        }
        int rowIndex = this.tablet.rowSize;
        this.tablet.addTimestamp(rowIndex, row.getTime());
        for (int i = 0; i < row.size(); ++i) {
            Object value = row.getObject(i);
            if (value instanceof Binary) {
                this.tablet.addValue(measurementSchemaArray[i].getMeasurementId(), rowIndex, (Object)PipeBinaryTransformer.transformToBinary((Binary)value));
            } else {
                this.tablet.addValue(measurementSchemaArray[i].getMeasurementId(), rowIndex, value);
            }
            if (!row.isNull(i)) continue;
            this.tablet.bitMaps[i].mark(rowIndex);
        }
        ++this.tablet.rowSize;
        if (this.tablet.rowSize == this.tablet.getMaxRowNumber()) {
            this.collectTabletInsertionEvent();
        }
    }

    private void collectTabletInsertionEvent() {
        if (this.tablet != null) {
            this.tabletInsertionEventList.add(new PipeRawTabletInsertionEvent(this.tablet, this.isAligned));
        }
        this.tablet = null;
    }

    public Iterable<TabletInsertionEvent> convertToTabletInsertionEvents() {
        this.collectTabletInsertionEvent();
        return this.tabletInsertionEventList;
    }
}

