/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.tsfile.write.record.Tablet;

public class PipeRawTabletInsertionEvent
implements TabletInsertionEvent {
    private final Tablet tablet;
    private final boolean isAligned;
    private final String pattern;
    private TabletInsertionDataContainer dataContainer;

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned) {
        this(tablet, isAligned, null);
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, String pattern) {
        this.tablet = Objects.requireNonNull(tablet);
        this.isAligned = isAligned;
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern == null ? "root" : this.pattern;
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.tablet, this.isAligned, this.getPattern());
        }
        return this.dataContainer.processRowByRow(consumer);
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.tablet, this.isAligned, this.getPattern());
        }
        return this.dataContainer.processTablet(consumer);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        String notNullPattern = this.getPattern();
        if (notNullPattern.equals("root")) {
            return this.tablet;
        }
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.tablet, this.isAligned, notNullPattern);
        }
        return this.dataContainer.convertToTablet();
    }
}

