/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.db.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionTsFileExtractor
extends PipeRealtimeDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionTsFileExtractor.class);
    private final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue();

    @Override
    public void extract(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
        if (!(event.getEvent() instanceof TsFileInsertionEvent)) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionTsFileExtractor.class.getName());
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            String errorMessage = String.format("extract: pending queue of PipeRealtimeDataRegionTsFileExtractor %s has reached capacity, discard TsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
            LOGGER.error(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionTsFileExtractor.class.getName());
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return true;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return false;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent = null;
            if (realtimeEvent.increaseReferenceCount(PipeRealtimeDataRegionTsFileExtractor.class.getName())) {
                suppliedEvent = realtimeEvent.getEvent();
            } else {
                String errorMessage = String.format("TsFile Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", realtimeEvent.getEvent());
                LOGGER.error(errorMessage);
                PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionTsFileExtractor.class.getName());
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.pendingQueue.clear();
    }
}

