/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.wal;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.MemTablePinException;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeWALResource
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeWALResource.class);
    protected final WALEntryHandler walEntryHandler;
    private final AtomicInteger referenceCount;
    public static final long MIN_TIME_TO_LIVE_IN_MS = 60000L;
    private final AtomicLong lastLogicalPinTime;
    private final AtomicBoolean isPhysicallyPinned;

    protected PipeWALResource(WALEntryHandler walEntryHandler) {
        this.walEntryHandler = walEntryHandler;
        this.referenceCount = new AtomicInteger(0);
        this.lastLogicalPinTime = new AtomicLong(0L);
        this.isPhysicallyPinned = new AtomicBoolean(false);
    }

    public final void pin() throws PipeRuntimeNonCriticalException {
        if (this.referenceCount.get() == 0) {
            if (!this.isPhysicallyPinned.get()) {
                try {
                    this.pinInternal();
                }
                catch (MemTablePinException e) {
                    throw new PipeRuntimeNonCriticalException(String.format("failed to pin wal %d, because %s", this.walEntryHandler.getMemTableId(), e.getMessage()));
                }
                this.isPhysicallyPinned.set(true);
                LOGGER.info("wal {} is pinned by pipe engine", (Object)this.walEntryHandler.getMemTableId());
            }
            this.lastLogicalPinTime.set(System.currentTimeMillis());
        }
        this.referenceCount.incrementAndGet();
    }

    protected abstract void pinInternal() throws MemTablePinException, PipeRuntimeNonCriticalException;

    public final void unpin() throws PipeRuntimeNonCriticalException {
        int finalReferenceCount = this.referenceCount.get();
        if (finalReferenceCount == 1) {
            this.unpinPhysicallyIfOutOfTimeToLive();
        } else if (finalReferenceCount < 1) {
            throw new PipeRuntimeCriticalException(String.format("wal %d is unpinned more than pinned, this should not happen", this.walEntryHandler.getMemTableId()));
        }
        this.referenceCount.decrementAndGet();
    }

    protected abstract void unpinInternal() throws MemTablePinException, PipeRuntimeNonCriticalException;

    public final boolean invalidateIfPossible() {
        if (this.referenceCount.get() > 0) {
            return false;
        }
        return this.unpinPhysicallyIfOutOfTimeToLive();
    }

    private boolean unpinPhysicallyIfOutOfTimeToLive() {
        if (this.isPhysicallyPinned.get()) {
            if (System.currentTimeMillis() - this.lastLogicalPinTime.get() > 60000L) {
                try {
                    this.unpinInternal();
                }
                catch (MemTablePinException e) {
                    throw new PipeRuntimeNonCriticalException(String.format("failed to unpin wal %d, because %s", this.walEntryHandler.getMemTableId(), e.getMessage()));
                }
                this.isPhysicallyPinned.set(false);
                LOGGER.info("wal {} is unpinned by pipe engine when checking time to live", (Object)this.walEntryHandler.getMemTableId());
                return true;
            }
            return false;
        }
        LOGGER.info("wal {} is not pinned physically when checking time to live", (Object)this.walEntryHandler.getMemTableId());
        return true;
    }

    @Override
    public final void close() {
        if (this.isPhysicallyPinned.get()) {
            try {
                this.unpinInternal();
            }
            catch (MemTablePinException e) {
                LOGGER.error("failed to unpin wal {} when closing pipe wal resource, because {}", (Object)this.walEntryHandler.getMemTableId(), (Object)e.getMessage());
            }
            this.isPhysicallyPinned.set(false);
            LOGGER.info("wal {} is unpinned by pipe engine when closing pipe wal resource", (Object)this.walEntryHandler.getMemTableId());
        }
        this.referenceCount.set(0);
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }
}

