/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCollector
implements EventCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCollector.class);
    private final BoundedBlockingPendingQueue<Event> pendingQueue;
    private final Queue<Event> bufferQueue;

    public PipeEventCollector(BoundedBlockingPendingQueue<Event> pendingQueue) {
        this.pendingQueue = pendingQueue;
        this.bufferQueue = new LinkedList<Event>();
    }

    public synchronized void collect(Event event) {
        if (event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName());
        }
        while (!this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            if (event instanceof PipeRawTabletInsertionEvent) {
                if (this.pendingQueue.put(bufferedEvent)) {
                    this.bufferQueue.poll();
                    continue;
                }
                LOGGER.warn("interrupted when putting event into pending queue, event: {}", (Object)event);
                this.bufferQueue.offer(event);
                return;
            }
            this.bufferQueue.offer(event);
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            if (event instanceof PipeRawTabletInsertionEvent) {
                if (!this.pendingQueue.put(event)) {
                    LOGGER.warn("interrupted when putting event into pending queue, event: {}", (Object)event);
                    this.bufferQueue.offer(event);
                }
            } else {
                this.bufferQueue.offer(event);
            }
        }
    }
}

