/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.processor;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.db.pipe.task.connection.EventSupplier;
import org.apache.iotdb.db.pipe.task.subtask.PipeSubtask;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtaskWorkerManager;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcessorSubtask
extends PipeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeProcessorSubtask.class);
    private static final AtomicReference<PipeProcessorSubtaskWorkerManager> subtaskWorkerManager = new AtomicReference();
    private final EventSupplier inputEventSupplier;
    private final PipeProcessor pipeProcessor;
    private final EventCollector outputEventCollector;
    private final AtomicBoolean isClosed;

    public PipeProcessorSubtask(String taskID, EventSupplier inputEventSupplier, PipeProcessor pipeProcessor, EventCollector outputEventCollector) {
        super(taskID);
        this.inputEventSupplier = inputEventSupplier;
        this.pipeProcessor = pipeProcessor;
        this.outputEventCollector = outputEventCollector;
        this.isClosed = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService ignored, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskScheduler = subtaskScheduler;
        if (subtaskWorkerManager.get() == null) {
            Class<PipeProcessorSubtaskWorkerManager> clazz = PipeProcessorSubtaskWorkerManager.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtaskWorkerManager.class
            if (subtaskWorkerManager.get() == null) {
                subtaskWorkerManager.set(new PipeProcessorSubtaskWorkerManager(subtaskWorkerThreadPoolExecutor));
            }
            // MONITOREXIT : clazz
        }
        subtaskWorkerManager.get().schedule(this);
    }

    @Override
    protected synchronized boolean executeOnce() throws Exception {
        Event event;
        this.lastEvent = event = this.lastEvent != null ? this.lastEvent : this.inputEventSupplier.supply();
        if (event == null) {
            return false;
        }
        try {
            if (event instanceof TabletInsertionEvent) {
                this.pipeProcessor.process((TabletInsertionEvent)event, this.outputEventCollector);
            } else if (event instanceof TsFileInsertionEvent) {
                this.pipeProcessor.process((TsFileInsertionEvent)event, this.outputEventCollector);
            } else {
                this.pipeProcessor.process(event, this.outputEventCollector);
            }
            this.releaseLastEvent();
        }
        catch (Exception e) {
            throw new PipeException("Error occurred during executing PipeProcessor#process, perhaps need to check whether the implementation of PipeProcessor is correct according to the pipe-api description.", (Throwable)e);
        }
        return true;
    }

    @Override
    public void submitSelf() {
    }

    @Override
    public synchronized void close() {
        try {
            this.isClosed.set(true);
            this.pipeProcessor.close();
            super.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeProcessor, perhaps need to check whether the implementation of PipeProcessor is correct according to the pipe-api description.", (Throwable)e);
        }
    }

    boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean equals(Object that) {
        return that instanceof PipeProcessorSubtask && this.taskID.equals(((PipeProcessorSubtask)that).taskID);
    }

    public int hashCode() {
        return this.taskID.hashCode();
    }
}

