/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceSchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.LogicalViewSchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.NodeSchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.PathsUsingTemplateSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TimeSeriesSchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.template.Template;

public class SchemaSourceFactory {
    private SchemaSourceFactory() {
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getTimeSeriesSchemaCountSource(PartialPath pathPattern, boolean isPrefixMatch, SchemaFilter schemaFilter, Map<Integer, Template> templateMap) {
        return new TimeSeriesSchemaSource(pathPattern, isPrefixMatch, 0L, 0L, schemaFilter, templateMap, false);
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getTimeSeriesSchemaScanSource(PartialPath pathPattern, boolean isPrefixMatch, long limit, long offset, SchemaFilter schemaFilter, Map<Integer, Template> templateMap) {
        return new TimeSeriesSchemaSource(pathPattern, isPrefixMatch, limit, offset, schemaFilter, templateMap, true);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getDeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath) {
        return new DeviceSchemaSource(pathPattern, isPrefixPath, 0L, 0L, false, null);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getDeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath, long limit, long offset, boolean hasSgCol, SchemaFilter schemaFilter) {
        return new DeviceSchemaSource(pathPattern, isPrefixPath, limit, offset, hasSgCol, schemaFilter);
    }

    public static ISchemaSource<INodeSchemaInfo> getNodeSchemaSource(PartialPath pathPattern, int level) {
        return new NodeSchemaSource(pathPattern, level);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getPathsUsingTemplateSource(List<PartialPath> pathPatternList, int templateId) {
        return new PathsUsingTemplateSource(pathPatternList, templateId);
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getLogicalViewSchemaSource(PartialPath pathPattern, long limit, long offset, SchemaFilter schemaFilter) {
        return new LogicalViewSchemaSource(pathPattern, limit, offset, schemaFilter);
    }
}

