/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public interface IWindowManager {
    public boolean isCurWindowInit();

    public void initCurWindow();

    public boolean hasNext(boolean var1);

    public void next();

    public IWindow getCurWindow();

    public TsBlock skipPointsOutOfCurWindow(TsBlock var1);

    default public boolean satisfiedCurWindow(TsBlock inputTsBlock) {
        return true;
    }

    default public boolean isTsBlockOutOfBound(TsBlock inputTsBlock) {
        return false;
    }

    default public List<TSDataType> getResultDataTypes(List<Aggregator> aggregators) {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        return dataTypes;
    }

    public TsBlockBuilder createResultTsBlockBuilder(List<Aggregator> var1);

    public void appendAggregationResult(TsBlockBuilder var1, List<Aggregator> var2);

    default public boolean notInitializedLastTimeWindow() {
        return false;
    }

    public boolean needSkipInAdvance();

    public boolean isIgnoringNull();

    default public void outputAggregators(List<Aggregator> aggregators, TsBlockBuilder resultTsBlockBuilder, long startTime, long endTime) {
        TimeColumnBuilder timeColumnBuilder = resultTsBlockBuilder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(startTime);
        ColumnBuilder[] columnBuilders = resultTsBlockBuilder.getValueColumnBuilders();
        int columnIndex = 0;
        if (endTime != -1L) {
            columnBuilders[0].writeLong(endTime);
            columnIndex = 1;
        }
        for (Aggregator aggregator : aggregators) {
            ColumnBuilder[] columnBuilder = new ColumnBuilder[aggregator.getOutputType().length];
            columnBuilder[0] = columnBuilders[columnIndex++];
            if (columnBuilder.length > 1) {
                columnBuilder[1] = columnBuilders[columnIndex++];
            }
            aggregator.outputResult(columnBuilder);
        }
        resultTsBlockBuilder.declarePosition();
    }
}

