/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindowParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockUtil;

public class TimeWindowManager
implements IWindowManager {
    private final TimeWindow curWindow;
    private final boolean ascending;
    private final ITimeRangeIterator timeRangeIterator;
    private final boolean needOutputEndTime;
    private boolean initialized;
    private boolean needSkip;
    private long startTime;
    private long endTime;

    public TimeWindowManager(ITimeRangeIterator timeRangeIterator, TimeWindowParameter timeWindowParameter) {
        this.timeRangeIterator = timeRangeIterator;
        this.initialized = false;
        this.curWindow = new TimeWindow(this.timeRangeIterator.nextTimeRange());
        this.needOutputEndTime = timeWindowParameter.isNeedOutputEndTime();
        this.ascending = timeRangeIterator.isAscending();
        this.needSkip = false;
    }

    @Override
    public boolean isCurWindowInit() {
        return this.initialized;
    }

    @Override
    public void initCurWindow() {
        this.initialized = true;
    }

    @Override
    public boolean hasNext(boolean hasMoreData) {
        return this.curWindow.getCurTimeRange() != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public void next() {
        this.needSkip = true;
        this.initialized = false;
        this.startTime = this.timeRangeIterator.currentOutputTime();
        this.endTime = this.curWindow.getCurMaxTime();
        this.curWindow.update(this.timeRangeIterator.nextTimeRange());
    }

    @Override
    public IWindow getCurWindow() {
        return this.curWindow;
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        if (!this.needSkip || inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        int positionCount = inputTsBlock.getPositionCount();
        int skipIndex = 0;
        if (this.satisfiedCurWindow(inputTsBlock)) {
            if (this.ascending && inputTsBlock.getStartTime() < this.curWindow.getCurMinTime() || !this.ascending && inputTsBlock.getStartTime() > this.curWindow.getCurMaxTime()) {
                skipIndex = TsBlockUtil.getFirstConditionIndex((TsBlock)inputTsBlock, (TimeRange)this.curWindow.getCurTimeRange(), (boolean)this.ascending);
            }
        } else if (this.ascending && inputTsBlock.getEndTime() < this.curWindow.getCurMinTime() || !this.ascending && inputTsBlock.getEndTime() > this.curWindow.getCurMaxTime()) {
            skipIndex = positionCount;
        }
        if (skipIndex < positionCount) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(skipIndex);
    }

    @Override
    public boolean satisfiedCurWindow(TsBlock inputTsBlock) {
        return AggregationUtil.satisfiedTimeRange(inputTsBlock, this.curWindow.getCurTimeRange(), this.ascending);
    }

    @Override
    public boolean isTsBlockOutOfBound(TsBlock inputTsBlock) {
        return inputTsBlock != null && (this.ascending ? inputTsBlock.getEndTime() > this.curWindow.getCurMaxTime() : inputTsBlock.getEndTime() < this.curWindow.getCurMinTime());
    }

    @Override
    public TsBlockBuilder createResultTsBlockBuilder(List<Aggregator> aggregators) {
        List<TSDataType> dataTypes = this.getResultDataTypes(aggregators);
        if (this.needOutputEndTime) {
            dataTypes.add(0, TSDataType.INT64);
        }
        return new TsBlockBuilder(dataTypes);
    }

    @Override
    public void appendAggregationResult(TsBlockBuilder resultTsBlockBuilder, List<Aggregator> aggregators) {
        this.outputAggregators(aggregators, resultTsBlockBuilder, this.startTime, this.needOutputEndTime ? this.endTime : -1L);
    }

    @Override
    public boolean notInitializedLastTimeWindow() {
        return !this.initialized;
    }

    @Override
    public boolean needSkipInAdvance() {
        return false;
    }

    @Override
    public boolean isIgnoringNull() {
        return true;
    }
}

