/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache;

import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache.ILastCacheContainer;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache.value.ILastCacheValue;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache.value.LastCacheValue;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LastCacheContainer
implements ILastCacheContainer {
    ILastCacheValue lastCacheValue;

    @Override
    public TimeValuePair getCachedLast() {
        return this.lastCacheValue == null ? null : this.lastCacheValue.getTimeValuePair();
    }

    @Override
    public synchronized int updateCachedLast(TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (highPriorityUpdate ? timeValuePair == null || timeValuePair.getValue() == null : timeValuePair == null) {
            return 0;
        }
        if (this.lastCacheValue == null) {
            if (!highPriorityUpdate || latestFlushedTime <= timeValuePair.getTimestamp()) {
                this.lastCacheValue = new LastCacheValue(timeValuePair.getTimestamp(), timeValuePair.getValue());
                return this.lastCacheValue.estimateSize();
            }
        } else if (timeValuePair.getTimestamp() > this.lastCacheValue.getTimestamp() || timeValuePair.getTimestamp() == this.lastCacheValue.getTimestamp() && highPriorityUpdate) {
            TsPrimitiveType oldValue = this.lastCacheValue.getValue();
            this.lastCacheValue.setTimestamp(timeValuePair.getTimestamp());
            this.lastCacheValue.setValue(timeValuePair.getValue());
            return this.getDiffSize(oldValue, timeValuePair.getValue());
        }
        return 0;
    }

    private int getDiffSize(TsPrimitiveType oldValue, TsPrimitiveType newValue) {
        if (oldValue == null) {
            return newValue == null ? 0 : newValue.getSize();
        }
        if (oldValue instanceof TsPrimitiveType.TsBinary) {
            return (newValue == null ? 0 : newValue.getSize()) - oldValue.getSize();
        }
        return newValue == null ? -oldValue.getSize() : 0;
    }

    @Override
    public int estimateSize() {
        return 16 + (this.lastCacheValue == null ? 0 : this.lastCacheValue.estimateSize());
    }
}

