/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDatabaseStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class CountDatabaseTask
implements IConfigTask {
    private final CountDatabaseStatement countDatabaseStatement;

    public CountDatabaseTask(CountDatabaseStatement countDatabaseStatement) {
        this.countDatabaseStatement = countDatabaseStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.countDatabase(this.countDatabaseStatement);
    }

    public static void buildTSBlock(int storageGroupNum, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeInt(storageGroupNum);
        builder.declarePosition();
        ColumnHeader storageGroupColumnHeader = new ColumnHeader("count", TSDataType.INT32);
        DatasetHeader datasetHeader = new DatasetHeader(Collections.singletonList(storageGroupColumnHeader), true);
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

