/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.view.BrokenViewException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;

public class CompleteMeasurementSchemaVisitor
extends ExpressionVisitor<Expression, ISchemaTree> {
    @Override
    public Expression process(Expression expression, ISchemaTree schemaTree) {
        return expression.accept(this, schemaTree);
    }

    @Override
    public Expression visitExpression(Expression expression, ISchemaTree schemaTree) {
        return expression;
    }

    @Override
    public Expression visitUnaryExpression(UnaryExpression unaryExpression, ISchemaTree schemaTree) {
        unaryExpression.setExpression(this.process(unaryExpression.getExpression(), schemaTree));
        return unaryExpression;
    }

    @Override
    public Expression visitBinaryExpression(BinaryExpression binaryExpression, ISchemaTree schemaTree) {
        binaryExpression.setLeftExpression(this.process(binaryExpression.getLeftExpression(), schemaTree));
        binaryExpression.setRightExpression(this.process(binaryExpression.getRightExpression(), schemaTree));
        return binaryExpression;
    }

    @Override
    public Expression visitTernaryExpression(TernaryExpression ternaryExpression, ISchemaTree schemaTree) {
        ternaryExpression.setFirstExpression(this.process(ternaryExpression.getFirstExpression(), schemaTree));
        ternaryExpression.setSecondExpression(this.process(ternaryExpression.getSecondExpression(), schemaTree));
        ternaryExpression.setThirdExpression(this.process(ternaryExpression.getThirdExpression(), schemaTree));
        return ternaryExpression;
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, ISchemaTree schemaTree) {
        List<Expression> children = functionExpression.getExpressions();
        ArrayList<Expression> replacedChildren = new ArrayList<Expression>();
        for (Expression child : children) {
            replacedChildren.add(this.process(child, schemaTree));
        }
        functionExpression.setExpressions(replacedChildren);
        return functionExpression;
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, ISchemaTree schemaTree) {
        PartialPath path = timeSeriesOperand.getPath();
        try {
            path.getMeasurementSchema();
        }
        catch (Exception notAMeasurementPath) {
            List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)path).left;
            if (actualPaths.size() != 1) {
                throw new SemanticException((Throwable)((Object)new BrokenViewException(path.getFullPath(), actualPaths)));
            }
            return new TimeSeriesOperand((PartialPath)actualPaths.get(0));
        }
        return timeSeriesOperand;
    }
}

