/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.BindSchemaForExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.CartesianProductVisitor;
import org.apache.iotdb.db.utils.TypeInferenceUtils;

public class BindSchemaForPredicateVisitor
extends CartesianProductVisitor<Context> {
    @Override
    public List<Expression> visitBinaryExpression(BinaryExpression binaryExpression, Context context) {
        List leftExpressions = (List)this.process(binaryExpression.getLeftExpression(), context.notRootClone());
        List rightExpressions = (List)this.process(binaryExpression.getRightExpression(), context.notRootClone());
        if (context.isRoot() && binaryExpression.getExpressionType() == ExpressionType.LOGIC_AND) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>(leftExpressions);
            resultExpressions.addAll(rightExpressions);
            return resultExpressions;
        }
        return ExpressionUtils.reconstructBinaryExpressions(binaryExpression, leftExpressions, rightExpressions);
    }

    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression predicate, Context context) {
        ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
        for (Expression suffixExpression : predicate.getExpressions()) {
            extendedExpressions.add((List)this.process(suffixExpression, new Context(context.getPrefixPaths(), context.getSchemaTree(), false)));
            if (!predicate.isBuiltInAggregationFunctionExpression()) continue;
            List<Expression> children = predicate.getExpressions();
            TypeInferenceUtils.bindTypeForAggregationNonSeriesInputExpressions(predicate.getFunctionName(), children, extendedExpressions);
            break;
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressions(predicate, childExpressionsList);
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand predicate, Context context) {
        PartialPath filterPath = predicate.getPath();
        ArrayList<PartialPath> concatPaths = new ArrayList<PartialPath>();
        if (!filterPath.getFirstNode().equals("root")) {
            context.getPrefixPaths().forEach(prefix -> concatPaths.add(prefix.concatPath(filterPath)));
        } else {
            concatPaths.add(filterPath);
        }
        ArrayList<MeasurementPath> nonViewPathList = new ArrayList<MeasurementPath>();
        ArrayList<MeasurementPath> viewPathList = new ArrayList<MeasurementPath>();
        for (PartialPath concatPath : concatPaths) {
            List actualPaths = (List)context.getSchemaTree().searchMeasurementPaths((PartialPath)concatPath).left;
            if (actualPaths.isEmpty()) {
                return Collections.singletonList(new NullOperand());
            }
            for (MeasurementPath measurementPath : actualPaths) {
                if (measurementPath.getMeasurementSchema().isLogicalView()) {
                    viewPathList.add(measurementPath);
                    continue;
                }
                nonViewPathList.add(measurementPath);
            }
        }
        List<Expression> reconstructTimeSeriesOperands = ExpressionUtils.reconstructTimeSeriesOperands(predicate, nonViewPathList);
        for (MeasurementPath measurementPath : viewPathList) {
            Expression replacedExpression = BindSchemaForExpressionVisitor.transformViewPath(measurementPath, context.getSchemaTree());
            replacedExpression.setViewPath((PartialPath)measurementPath);
            reconstructTimeSeriesOperands.add(replacedExpression);
        }
        return reconstructTimeSeriesOperands;
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return Collections.singletonList(constantOperand);
    }

    public static class Context {
        private final List<PartialPath> prefixPaths;
        private final ISchemaTree schemaTree;
        private final boolean isRoot;

        public Context(List<PartialPath> prefixPaths, ISchemaTree schemaTree, boolean isRoot) {
            this.prefixPaths = prefixPaths;
            this.schemaTree = schemaTree;
            this.isRoot = isRoot;
        }

        public Context notRootClone() {
            return new Context(this.prefixPaths, this.schemaTree, false);
        }

        public List<PartialPath> getPrefixPaths() {
            return this.prefixPaths;
        }

        public ISchemaTree getSchemaTree() {
            return this.schemaTree;
        }

        public boolean isRoot() {
            return this.isRoot;
        }
    }
}

