/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeJoinNode
extends MultiChildProcessNode {
    private final Ordering mergeOrder;

    public TimeJoinNode(PlanNodeId id, Ordering mergeOrder) {
        super(id, new ArrayList<PlanNode>());
        this.mergeOrder = mergeOrder;
    }

    public TimeJoinNode(PlanNodeId id, Ordering mergeOrder, List<PlanNode> children) {
        super(id, children);
        this.mergeOrder = mergeOrder;
    }

    public Ordering getMergeOrder() {
        return this.mergeOrder;
    }

    @Override
    public PlanNode clone() {
        return new TimeJoinNode(this.getPlanNodeId(), this.getMergeOrder());
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new TimeJoinNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), this.getMergeOrder(), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)));
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.children.stream().map(PlanNode::getOutputColumnNames).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTimeJoin(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TIME_JOIN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.mergeOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TIME_JOIN.serialize(stream);
        ReadWriteIOUtils.write((int)this.mergeOrder.ordinal(), (OutputStream)stream);
    }

    public static TimeJoinNode deserialize(ByteBuffer byteBuffer) {
        Ordering mergeOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TimeJoinNode(planNodeId, mergeOrder);
    }

    public String toString() {
        return "TimeJoinNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeJoinNode that = (TimeJoinNode)o;
        return this.mergeOrder == that.mergeOrder && this.children.equals(that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mergeOrder, this.children});
    }
}

