/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InsertRowsOfOneDeviceNode
extends InsertNode {
    private List<Integer> insertRowNodeIndexList;
    private List<InsertRowNode> insertRowNodeList;
    private Map<Integer, TSStatus> results = new HashMap<Integer, TSStatus>();

    public InsertRowsOfOneDeviceNode(PlanNodeId id) {
        super(id);
        this.insertRowNodeIndexList = new ArrayList<Integer>();
        this.insertRowNodeList = new ArrayList<InsertRowNode>();
    }

    public InsertRowsOfOneDeviceNode(PlanNodeId id, List<Integer> insertRowNodeIndexList, List<InsertRowNode> insertRowNodeList) {
        super(id);
        this.insertRowNodeIndexList = insertRowNodeIndexList;
        this.insertRowNodeList = insertRowNodeList;
    }

    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    @Override
    public void setSearchIndex(long index) {
        this.searchIndex = index;
        this.insertRowNodeList.forEach(plan -> plan.setSearchIndex(index));
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, (int)this.insertRowNodeList.size());
    }

    public List<Integer> getInsertRowNodeIndexList() {
        return this.insertRowNodeIndexList;
    }

    public void setInsertRowNodeIndexList(List<Integer> insertRowNodeIndexList) {
        this.insertRowNodeIndexList = insertRowNodeIndexList;
    }

    public List<InsertRowNode> getInsertRowNodeList() {
        return this.insertRowNodeList;
    }

    public void setInsertRowNodeList(List<InsertRowNode> insertRowNodeList) {
        this.insertRowNodeList = insertRowNodeList;
        if (insertRowNodeList == null || insertRowNodeList.isEmpty()) {
            return;
        }
        this.devicePath = insertRowNodeList.get(0).getDevicePath();
        this.isAligned = insertRowNodeList.get((int)0).isAligned;
        this.storeMeasurementsAndDataType();
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        HashMap<TRegionReplicaSet, List> splitMap = new HashMap<TRegionReplicaSet, List>();
        HashMap<TRegionReplicaSet, List> splitMapForIndex = new HashMap<TRegionReplicaSet, List>();
        for (int i = 0; i < this.insertRowNodeList.size(); ++i) {
            InsertRowNode insertRowNode = this.insertRowNodeList.get(i);
            TRegionReplicaSet dataRegionReplicaSet = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(this.devicePath.getFullPath(), TimePartitionUtils.getTimePartition(insertRowNode.getTime()));
            List tmpMap = splitMap.computeIfAbsent(dataRegionReplicaSet, k -> new ArrayList());
            List tmpIndexMap = splitMapForIndex.computeIfAbsent(dataRegionReplicaSet, k -> new ArrayList());
            tmpMap.add(insertRowNode);
            tmpIndexMap.add(this.insertRowNodeIndexList.get(i));
            if (i != this.insertRowNodeList.size() - 1) continue;
            analysis.setRedirectNodeList(Collections.singletonList(((TDataNodeLocation)dataRegionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint()));
        }
        for (Map.Entry entry : splitMap.entrySet()) {
            InsertRowsOfOneDeviceNode reducedNode = new InsertRowsOfOneDeviceNode(this.getPlanNodeId());
            reducedNode.setInsertRowNodeList((List)entry.getValue());
            reducedNode.setInsertRowNodeIndexList((List)splitMapForIndex.get(entry.getKey()));
            reducedNode.setDataRegionReplicaSet((TRegionReplicaSet)entry.getKey());
            result.add(reducedNode);
        }
        return result;
    }

    private void storeMeasurementsAndDataType() {
        HashSet<String> measurementSet = new HashSet<String>();
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        ArrayList<String> measurementList = new ArrayList<String>();
        for (InsertRowNode insertRowNode : this.insertRowNodeList) {
            String[] measurements = insertRowNode.getMeasurements();
            TSDataType[] dataTypes = insertRowNode.getDataTypes();
            for (int i = 0; i < measurements.length; ++i) {
                if (measurementSet.contains(measurements[i])) continue;
                measurementList.add(measurements[i]);
                dataTypeList.add(dataTypes[i]);
                measurementSet.add(measurements[i]);
            }
        }
        this.measurements = measurementList.toArray(new String[0]);
        this.dataTypes = dataTypeList.toArray(new TSDataType[0]);
    }

    public static InsertRowsOfOneDeviceNode deserialize(ByteBuffer byteBuffer) {
        int i;
        PartialPath devicePath;
        ArrayList<InsertRowNode> insertRowNodeList = new ArrayList<InsertRowNode>();
        ArrayList<Integer> insertRowNodeIndex = new ArrayList<Integer>();
        try {
            devicePath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowsOfOneDeviceNode", e);
        }
        int size = byteBuffer.getInt();
        for (i = 0; i < size; ++i) {
            InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""));
            insertRowNode.setDevicePath(devicePath);
            insertRowNode.setTime(byteBuffer.getLong());
            insertRowNode.deserializeMeasurementsAndValues(byteBuffer);
            insertRowNodeList.add(insertRowNode);
        }
        for (i = 0; i < size; ++i) {
            insertRowNodeIndex.add(byteBuffer.getInt());
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        for (InsertRowNode insertRowNode : insertRowNodeList) {
            insertRowNode.setPlanNodeId(planNodeId);
        }
        InsertRowsOfOneDeviceNode insertRowsOfOneDeviceNode = new InsertRowsOfOneDeviceNode(planNodeId);
        insertRowsOfOneDeviceNode.setInsertRowNodeList(insertRowNodeList);
        insertRowsOfOneDeviceNode.setInsertRowNodeIndexList(insertRowNodeIndex);
        insertRowsOfOneDeviceNode.setDevicePath(devicePath);
        return insertRowsOfOneDeviceNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INSERT_ROWS_OF_ONE_DEVICE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.devicePath.getFullPath(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.insertRowNodeList.size(), (ByteBuffer)byteBuffer);
        for (InsertRowNode node : this.insertRowNodeList) {
            ReadWriteIOUtils.write((long)node.getTime(), (ByteBuffer)byteBuffer);
            node.serializeMeasurementsAndValues(byteBuffer);
        }
        for (Integer index : this.insertRowNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INSERT_ROWS_OF_ONE_DEVICE.serialize(stream);
        ReadWriteIOUtils.write((String)this.devicePath.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.insertRowNodeList.size(), (OutputStream)stream);
        for (InsertRowNode node : this.insertRowNodeList) {
            ReadWriteIOUtils.write((long)node.getTime(), (OutputStream)stream);
            node.serializeMeasurementsAndValues(stream);
        }
        for (Integer index : this.insertRowNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (OutputStream)stream);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertRowsOfOneDeviceNode that = (InsertRowsOfOneDeviceNode)o;
        return Objects.equals(this.insertRowNodeIndexList, that.insertRowNodeIndexList) && Objects.equals(this.insertRowNodeList, that.insertRowNodeList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.insertRowNodeIndexList, this.insertRowNodeList);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRowsOfOneDevice(this, context);
    }

    @Override
    public long getMinTime() {
        throw new NotImplementedException();
    }

    @Override
    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
        this.insertRowNodeList.forEach(insertRowNode -> insertRowNode.setProgressIndex(progressIndex));
    }
}

