/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FillDescriptor {
    private final FillPolicy fillPolicy;
    private Literal fillValue;

    public FillDescriptor(FillPolicy fillPolicy) {
        this.fillPolicy = fillPolicy;
    }

    public FillDescriptor(FillPolicy fillPolicy, Literal fillValue) {
        this.fillPolicy = fillPolicy;
        this.fillValue = fillValue;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.fillPolicy.ordinal(), (ByteBuffer)byteBuffer);
        if (this.fillPolicy == FillPolicy.VALUE) {
            this.fillValue.serialize(byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.fillPolicy.ordinal(), (OutputStream)stream);
        if (this.fillPolicy == FillPolicy.VALUE) {
            this.fillValue.serialize(stream);
        }
    }

    public static FillDescriptor deserialize(ByteBuffer byteBuffer) {
        FillPolicy fillPolicy = FillPolicy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        if (fillPolicy == FillPolicy.VALUE) {
            Literal fillValue = Literal.deserialize(byteBuffer);
            return new FillDescriptor(fillPolicy, fillValue);
        }
        return new FillDescriptor(fillPolicy);
    }

    public FillPolicy getFillPolicy() {
        return this.fillPolicy;
    }

    public Literal getFillValue() {
        return this.fillValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillDescriptor that = (FillDescriptor)o;
        return this.fillPolicy == that.fillPolicy && Objects.equals(this.fillValue, that.fillValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fillPolicy, this.fillValue});
    }
}

