/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DoubleLiteral
extends Literal {
    private final double value;

    public DoubleLiteral(String value) {
        this.value = Double.parseDouble(value);
    }

    public DoubleLiteral(double value) {
        this.value = value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.DOUBLE.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((double)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.DOUBLE.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((double)this.value, (OutputStream)stream);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        return dataType == TSDataType.FLOAT || dataType == TSDataType.DOUBLE || dataType == TSDataType.TEXT;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.DOUBLE.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLiteral that = (DoubleLiteral)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return (float)this.value;
    }

    @Override
    public Binary getBinary() {
        return new Binary(String.valueOf(this.value));
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

