/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class DatabaseSchemaStatement
extends Statement
implements IConfigStatement {
    private final DatabaseSchemaStatementType subType;
    private PartialPath databasePath;
    private Long ttl = null;
    private Integer schemaReplicationFactor = null;
    private Integer dataReplicationFactor = null;
    private Long timePartitionInterval = null;
    private Integer schemaRegionGroupNum = null;
    private Integer dataRegionGroupNum = null;
    private boolean enablePrintExceptionLog = true;

    public DatabaseSchemaStatement(DatabaseSchemaStatementType subType) {
        this.subType = subType;
        this.statementType = StatementType.STORAGE_GROUP_SCHEMA;
    }

    public DatabaseSchemaStatementType getSubType() {
        return this.subType;
    }

    public PartialPath getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(PartialPath databasePath) {
        this.databasePath = databasePath;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Integer getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(Integer schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public Integer getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(Integer dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public Long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(Long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public Integer getSchemaRegionGroupNum() {
        return this.schemaRegionGroupNum;
    }

    public void setSchemaRegionGroupNum(Integer schemaRegionGroupNum) {
        this.schemaRegionGroupNum = schemaRegionGroupNum;
    }

    public Integer getDataRegionGroupNum() {
        return this.dataRegionGroupNum;
    }

    public void setDataRegionGroupNum(Integer dataRegionGroupNum) {
        this.dataRegionGroupNum = dataRegionGroupNum;
    }

    public boolean getEnablePrintExceptionLog() {
        return this.enablePrintExceptionLog;
    }

    public void setEnablePrintExceptionLog(boolean enablePrintExceptionLog) {
        this.enablePrintExceptionLog = enablePrintExceptionLog;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        switch (this.subType) {
            case CREATE: {
                return visitor.visitSetDatabase(this, context);
            }
        }
        return visitor.visitAlterDatabase(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.databasePath != null ? Collections.singletonList(this.databasePath) : Collections.emptyList();
    }

    public String toString() {
        return "SetStorageGroupStatement{storageGroupPath=" + this.databasePath + ", ttl=" + this.ttl + ", schemaReplicationFactor=" + this.schemaReplicationFactor + ", dataReplicationFactor=" + this.dataReplicationFactor + ", timePartitionInterval=" + this.timePartitionInterval + ", schemaRegionGroupNum=" + this.schemaRegionGroupNum + ", dataRegionGroupNum=" + this.dataRegionGroupNum + '}';
    }

    public static enum DatabaseSchemaStatementType {
        CREATE,
        ALTER;

    }
}

