/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;

public class DropTriggerStatement
extends Statement
implements IConfigStatement {
    private final String triggerName;
    private PartialPath authPath;

    public DropTriggerStatement(String triggerName) {
        this.statementType = StatementType.DROP_TRIGGER;
        this.triggerName = triggerName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDropTrigger(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public boolean isAuthenticationRequired() {
        if (this.authPath == null) {
            TriggerInformation information = TriggerManagementService.getInstance().getTriggerInformation(this.triggerName);
            if (information == null) {
                return false;
            }
            this.authPath = information.getPathPattern();
        }
        return true;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.isAuthenticationRequired() ? Collections.singletonList(this.authPath) : Collections.emptyList();
    }
}

