/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public class InColumnTransformer
extends UnaryColumnTransformer {
    private final Satisfy satisfy;
    private final TypeEnum childType;
    private Set<Integer> intSet;
    private Set<Long> longSet;
    private Set<Float> floatSet;
    private Set<Double> doubleSet;
    private Set<Boolean> booleanSet;
    private Set<String> stringSet;

    public InColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, boolean isNotIn, Set<String> values) {
        super(returnType, childColumnTransformer);
        this.satisfy = isNotIn ? new NotInSatisfy() : new InSatisfy();
        this.childType = childColumnTransformer.getType() == null ? null : childColumnTransformer.getType().getTypeEnum();
        this.initTypedSet(values);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        block8: for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                switch (this.childType) {
                    case INT32: {
                        this.returnType.writeBoolean(columnBuilder, this.satisfy.of(column.getInt(i)));
                        continue block8;
                    }
                    case INT64: {
                        this.returnType.writeBoolean(columnBuilder, this.satisfy.of(column.getLong(i)));
                        continue block8;
                    }
                    case FLOAT: {
                        this.returnType.writeBoolean(columnBuilder, this.satisfy.of(column.getFloat(i)));
                        continue block8;
                    }
                    case DOUBLE: {
                        this.returnType.writeBoolean(columnBuilder, this.satisfy.of(column.getDouble(i)));
                        continue block8;
                    }
                    case BOOLEAN: {
                        this.returnType.writeBoolean(columnBuilder, this.satisfy.of(column.getBoolean(i)));
                        continue block8;
                    }
                    case BINARY: {
                        this.returnType.writeBoolean(columnBuilder, this.satisfy.of(column.getBinary(i).getStringValue()));
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported data type: " + this.childType);
                    }
                }
            }
            columnBuilder.appendNull();
        }
    }

    private void initTypedSet(Set<String> values) {
        if (this.childType == null) {
            return;
        }
        String errorMsg = "\"%s\" cannot be cast to [%s]";
        switch (this.childType) {
            case INT32: {
                this.intSet = new HashSet<Integer>();
                for (String value : values) {
                    try {
                        this.intSet.add(Integer.valueOf(value));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SemanticException(String.format(errorMsg, value, this.childType));
                    }
                }
                break;
            }
            case INT64: {
                this.longSet = new HashSet<Long>();
                for (String value : values) {
                    try {
                        this.longSet.add(Long.valueOf(value));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SemanticException(String.format(errorMsg, value, this.childType));
                    }
                }
                break;
            }
            case FLOAT: {
                this.floatSet = new HashSet<Float>();
                for (String value : values) {
                    try {
                        this.floatSet.add(Float.valueOf(value));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SemanticException(String.format(errorMsg, value, this.childType));
                    }
                }
                break;
            }
            case DOUBLE: {
                this.doubleSet = new HashSet<Double>();
                for (String value : values) {
                    try {
                        this.doubleSet.add(Double.valueOf(value));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SemanticException(String.format(errorMsg, value, this.childType));
                    }
                }
                break;
            }
            case BOOLEAN: {
                this.booleanSet = new HashSet<Boolean>();
                for (String value : values) {
                    this.booleanSet.add(this.strictCastToBool(value));
                }
                break;
            }
            case BINARY: {
                this.stringSet = values;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported data type: " + this.childType);
            }
        }
    }

    private boolean strictCastToBool(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s)) {
            return false;
        }
        throw new SemanticException(String.format("\"%s\" cannot be cast to [BOOLEAN]", s));
    }

    private class NotInSatisfy
    implements Satisfy {
        private NotInSatisfy() {
        }

        @Override
        public boolean of(int intValue) {
            return !InColumnTransformer.this.intSet.contains(intValue);
        }

        @Override
        public boolean of(long longValue) {
            return !InColumnTransformer.this.longSet.contains(longValue);
        }

        @Override
        public boolean of(float floatValue) {
            return !InColumnTransformer.this.floatSet.contains(Float.valueOf(floatValue));
        }

        @Override
        public boolean of(double doubleValue) {
            return !InColumnTransformer.this.doubleSet.contains(doubleValue);
        }

        @Override
        public boolean of(boolean booleanValue) {
            return !InColumnTransformer.this.booleanSet.contains(booleanValue);
        }

        @Override
        public boolean of(String stringValue) {
            return !InColumnTransformer.this.stringSet.contains(stringValue);
        }
    }

    private class InSatisfy
    implements Satisfy {
        private InSatisfy() {
        }

        @Override
        public boolean of(int intValue) {
            return InColumnTransformer.this.intSet.contains(intValue);
        }

        @Override
        public boolean of(long longValue) {
            return InColumnTransformer.this.longSet.contains(longValue);
        }

        @Override
        public boolean of(float floatValue) {
            return InColumnTransformer.this.floatSet.contains(Float.valueOf(floatValue));
        }

        @Override
        public boolean of(double doubleValue) {
            return InColumnTransformer.this.doubleSet.contains(doubleValue);
        }

        @Override
        public boolean of(boolean booleanValue) {
            return InColumnTransformer.this.booleanSet.contains(booleanValue);
        }

        @Override
        public boolean of(String stringValue) {
            return InColumnTransformer.this.stringSet.contains(stringValue);
        }
    }

    private static interface Satisfy {
        public boolean of(int var1);

        public boolean of(long var1);

        public boolean of(float var1);

        public boolean of(double var1);

        public boolean of(boolean var1);

        public boolean of(String var1);
    }
}

