/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.tv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SerializableBinaryTVList
extends SerializableTVList {
    protected static final int MIN_OBJECT_HEADER_SIZE = 8;
    protected static final int MIN_ARRAY_HEADER_SIZE = 12;

    protected static int calculateCapacity(float memoryLimitInMB, int byteArrayLength) {
        float memoryLimitInB = memoryLimitInMB * 1048576.0f / 2.0f;
        return 1000 * (int)(memoryLimitInB / (1000.0f * SerializableBinaryTVList.calculateSingleBinaryTVPairMemory(byteArrayLength)));
    }

    protected static float calculateSingleBinaryTVPairMemory(int byteArrayLength) {
        return (float)(28 + byteArrayLength) + 0.125f;
    }

    protected SerializableBinaryTVList(SerializableList.SerializationRecorder serializationRecorder) {
        super(TSDataType.TEXT, serializationRecorder);
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int size = this.length();
        this.serializationRecorder.setSerializedElementSize(size);
        int serializedByteLength = 0;
        for (int i = 0; i < size; ++i) {
            serializedByteLength += ReadWriteIOUtils.write((long)this.getTimeByIndex(i), (OutputStream)outputStream);
            serializedByteLength += ReadWriteIOUtils.write((Binary)this.getBinaryByIndex(i), (OutputStream)outputStream);
        }
        this.serializationRecorder.setSerializedByteLength(serializedByteLength);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int serializedElementSize = this.serializationRecorder.getSerializedElementSize();
        for (int i = 0; i < serializedElementSize; ++i) {
            this.putBinary(ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer), ReadWriteIOUtils.readBinary((ByteBuffer)byteBuffer));
        }
    }

    @Override
    public void release() {
        this.timeRet = null;
        this.binaryRet = null;
    }
}

