/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaRegionCachedMetric
implements ISchemaRegionMetric {
    private static final String PINNED_NODE_NUM = "schema_file_pinned_num";
    private static final String UNPINNED_NODE_NUM = "schema_file_unpinned_num";
    private static final String PINNED_MEM_SIZE = "schema_file_pinned_mem";
    private static final String UNPINNED_MEM_SIZE = "schema_file_unpinned_mem";
    private static final String BUFFER_NODE_NUM = "schema_file_buffer_node_num";
    private static final String CACHE_NODE_NUM = "schema_file_cache_node_num";
    private static final String MLOG_LENGTH = "schema_file_mlog_length";
    private static final String MLOG_CHECKPOINT = "schema_file_mlog_checkpoint";
    private final CachedSchemaRegionStatistics regionStatistics;
    private final String regionTagValue;
    private final SchemaRegionMemMetric memSchemaRegionMetric;

    public SchemaRegionCachedMetric(CachedSchemaRegionStatistics regionStatistics) {
        this.regionStatistics = regionStatistics;
        this.regionTagValue = String.format("SchemaRegion[%d]", regionStatistics.getSchemaRegionId());
        this.memSchemaRegionMetric = new SchemaRegionMemMetric(regionStatistics);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.memSchemaRegionMetric.bindTo(metricService);
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getPinnedMNodeNum, new String[]{Tag.NAME.toString(), PINNED_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getUnpinnedMNodeNum, new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getPinnedMemorySize, new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getUnpinnedMemorySize, new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getBufferNodeNum, new String[]{Tag.NAME.toString(), BUFFER_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getCacheNodeNum, new String[]{Tag.NAME.toString(), CACHE_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, MemSchemaRegionStatistics::getMlogLength, new String[]{Tag.NAME.toString(), MLOG_LENGTH, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getMlogCheckPoint, new String[]{Tag.NAME.toString(), MLOG_CHECKPOINT, Tag.REGION.toString(), this.regionTagValue});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.memSchemaRegionMetric.unbindFrom(metricService);
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), PINNED_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), BUFFER_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), CACHE_NODE_NUM, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), MLOG_LENGTH, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), MLOG_CHECKPOINT, Tag.REGION.toString(), this.regionTagValue});
    }
}

