/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaRegionMemMetric
implements ISchemaRegionMetric {
    private static final String MEM_USAGE = "schema_region_mem_usage";
    private static final String SERIES_CNT = "schema_region_series_cnt";
    private static final String TEMPLATE_CNT = "activated_template_cnt";
    private static final String TEMPLATE_SERIES_CNT = "template_series_cnt";
    private final MemSchemaRegionStatistics regionStatistics;
    private final String regionTagValue;

    public SchemaRegionMemMetric(MemSchemaRegionStatistics regionStatistics) {
        this.regionStatistics = regionStatistics;
        this.regionTagValue = String.format("SchemaRegion[%d]", regionStatistics.getSchemaRegionId());
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, MemSchemaRegionStatistics::getRegionMemoryUsage, new String[]{Tag.NAME.toString(), MEM_USAGE, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, MemSchemaRegionStatistics::getSeriesNumber, new String[]{Tag.NAME.toString(), SERIES_CNT, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, MemSchemaRegionStatistics::getTemplateActivatedNumber, new String[]{Tag.NAME.toString(), TEMPLATE_CNT, Tag.REGION.toString(), this.regionTagValue});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, MemSchemaRegionStatistics::getTemplateSeriesNumber, new String[]{Tag.NAME.toString(), TEMPLATE_SERIES_CNT, Tag.REGION.toString(), this.regionTagValue});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), MEM_USAGE, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), SERIES_CNT, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), TEMPLATE_CNT, Tag.REGION.toString(), this.regionTagValue});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), TEMPLATE_SERIES_CNT, Tag.REGION.toString(), this.regionTagValue});
    }
}

