/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.ICacheManager;

public class CachedSchemaRegionStatistics
extends MemSchemaRegionStatistics {
    private final AtomicLong unpinnedMemorySize = new AtomicLong(0L);
    private final AtomicLong pinnedMemorySize = new AtomicLong(0L);
    private final AtomicLong unpinnedMNodeNum = new AtomicLong(0L);
    private final AtomicLong pinnedMNodeNum = new AtomicLong(0L);
    private long mlogCheckPoint = 0L;
    private ICacheManager cacheManager;
    private final CachedSchemaEngineStatistics cachedEngineStatistics = this.schemaEngineStatistics.getAsCachedSchemaEngineStatistics();

    public CachedSchemaRegionStatistics(int schemaRegionId, ISchemaEngineStatistics engineStatistics) {
        super(schemaRegionId, engineStatistics);
    }

    public void updatePinnedMNodeNum(int delta) {
        this.pinnedMNodeNum.addAndGet(delta);
        this.cachedEngineStatistics.updatePinnedMNodeNum(delta);
    }

    public void updateUnpinnedMNodeNum(int delta) {
        this.unpinnedMNodeNum.addAndGet(delta);
        this.cachedEngineStatistics.updateUnpinnedMNodeNum(delta);
    }

    public void updatePinnedMemorySize(int delta) {
        this.pinnedMemorySize.addAndGet(delta);
        this.cachedEngineStatistics.updatePinnedMemorySize(delta);
    }

    public void updateUnpinnedMemorySize(int delta) {
        this.unpinnedMemorySize.addAndGet(delta);
        this.cachedEngineStatistics.updateUnpinnedMemorySize(delta);
    }

    public void setMlogCheckPoint(long mlogCheckPoint) {
        this.mlogCheckPoint = mlogCheckPoint;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public long getUnpinnedMemorySize() {
        return this.unpinnedMemorySize.get();
    }

    public long getPinnedMemorySize() {
        return this.pinnedMemorySize.get();
    }

    public long getUnpinnedMNodeNum() {
        return this.unpinnedMNodeNum.get();
    }

    public long getPinnedMNodeNum() {
        return this.pinnedMNodeNum.get();
    }

    public long getMlogCheckPoint() {
        return this.mlogCheckPoint;
    }

    public long getBufferNodeNum() {
        return this.cacheManager == null ? 0L : this.cacheManager.getBufferNodeNum();
    }

    public long getCacheNodeNum() {
        return this.cacheManager == null ? 0L : this.cacheManager.getCacheNodeNum();
    }

    @Override
    public CachedSchemaRegionStatistics getAsCachedSchemaRegionStatistics() {
        return this;
    }

    @Override
    public MemSchemaRegionStatistics getAsMemSchemaRegionStatistics() {
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.cachedEngineStatistics.updatePinnedMNodeNum(-this.pinnedMNodeNum.get());
        this.cachedEngineStatistics.updateUnpinnedMNodeNum(-this.unpinnedMNodeNum.get());
        this.cachedEngineStatistics.updatePinnedMemorySize(-this.pinnedMemorySize.get());
        this.cachedEngineStatistics.updateUnpinnedMemorySize(-this.unpinnedMemorySize.get());
    }
}

