/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.Traverser;

public abstract class MNodeTraverser<R, N extends IMNode<N>>
extends Traverser<R, N> {
    protected int targetLevel = -1;
    protected N lastVisitNode = null;

    public MNodeTraverser(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected boolean mayTargetNodeType(N node) {
        return true;
    }

    protected boolean acceptFullMatchedNode(N node) {
        if (this.targetLevel >= 0) {
            if (this.getSizeOfAncestor() > this.targetLevel) {
                return this.getAncestorNodeByLevel(this.targetLevel) != this.lastVisitNode;
            }
            if (this.getSizeOfAncestor() == this.targetLevel) {
                return node != this.lastVisitNode;
            }
            return false;
        }
        return true;
    }

    protected boolean acceptInternalMatchedNode(N node) {
        return false;
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(N node) {
        return !node.isMeasurement();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(N node) {
        return !node.isMeasurement();
    }

    public void setTargetLevel(int targetLevel) {
        this.targetLevel = targetLevel;
    }

    protected final R generateResult(N nextMatchedNode) {
        if (this.targetLevel >= 0) {
            this.lastVisitNode = this.getLevelOfNextMatchedNode() == this.targetLevel ? nextMatchedNode : (IMNode)this.getAncestorNodeByLevel(this.targetLevel);
            return this.transferToResult(this.lastVisitNode);
        }
        return this.transferToResult(nextMatchedNode);
    }

    protected abstract R transferToResult(N var1);
}

