/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.template;

import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUtil;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTemplateManager
implements ITemplateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTemplateManager.class);
    private final Map<Integer, Template> templateIdMap = new ConcurrentHashMap<Integer, Template>();
    private final Map<String, Integer> templateNameMap = new ConcurrentHashMap<String, Integer>();
    private final Map<PartialPath, Integer> pathSetTemplateMap = new ConcurrentHashMap<PartialPath, Integer>();
    private final Map<Integer, List<PartialPath>> templateSetOnPathsMap = new ConcurrentHashMap<Integer, List<PartialPath>>();
    private final Map<PartialPath, Integer> pathPreSetTemplateMap = new ConcurrentHashMap<PartialPath, Integer>();
    private final Map<Integer, Set<PartialPath>> templatePreSetOnPathsMap = new ConcurrentHashMap<Integer, Set<PartialPath>>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();

    public static ClusterTemplateManager getInstance() {
        return ClusterTemplateManagerHolder.INSTANCE;
    }

    @Override
    public TSStatus createSchemaTemplate(CreateSchemaTemplateStatement statement) {
        TCreateSchemaTemplateReq req = this.constructTCreateSchemaTemplateReq(statement);
        ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            List<TSDataType> dataTypes = statement.getDataTypes();
            List<TSEncoding> encodings = statement.getEncodings();
            for (int i = 0; i < dataTypes.size(); ++i) {
                SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i), encodings.get(i));
            }
            TSStatus tsStatus = configNodeClient.createSchemaTemplate(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute create schema template {} in config node, status is {}.", (Object)statement.getName(), (Object)tsStatus);
            }
            TSStatus tSStatus = tsStatus;
            if (configNodeClient != null) {
                configNodeClient.close();
            }
            return tSStatus;
        }
        catch (Throwable throwable) {
            try {
                if (configNodeClient != null) {
                    try {
                        configNodeClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MetadataException e) {
                throw new RuntimeException(new IoTDBException("create template error -" + e.getMessage(), (Throwable)e, TSStatusCode.CREATE_TEMPLATE_ERROR.getStatusCode()));
            }
            catch (ClientManagerException | TException e) {
                throw new RuntimeException(new IoTDBException("create template error.", e, TSStatusCode.CREATE_TEMPLATE_ERROR.getStatusCode()));
            }
        }
    }

    private TCreateSchemaTemplateReq constructTCreateSchemaTemplateReq(CreateSchemaTemplateStatement statement) {
        TCreateSchemaTemplateReq req = new TCreateSchemaTemplateReq();
        try {
            Template template = new Template(statement.getName(), statement.getMeasurements(), statement.getDataTypes(), statement.getEncodings(), statement.getCompressors(), statement.isAligned());
            req.setName(template.getName());
            req.setSerializedTemplate(template.serialize());
        }
        catch (IllegalPathException e) {
            throw new SchemaExecutionException((Throwable)e);
        }
        return req;
    }

    @Override
    public List<Template> getAllTemplates() {
        ArrayList<Template> templatesList;
        block9: {
            templatesList = new ArrayList<Template>();
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TGetAllTemplatesResp resp = configNodeClient.getAllTemplates();
                if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    List list = resp.getTemplateList();
                    list.forEach(templateData -> {
                        Template template = new Template();
                        template.deserialize((ByteBuffer)templateData);
                        templatesList.add(template);
                    });
                    break block9;
                }
                throw new RuntimeException(new IoTDBException(resp.getStatus().getMessage(), resp.getStatus().getCode()));
            }
            catch (ClientManagerException | TException e) {
                throw new RuntimeException(new IoTDBException("get all template error.", TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode()));
            }
        }
        return templatesList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Template getTemplate(String name) throws IoTDBException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetTemplateResp resp = configNodeClient.getTemplate(name);
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) throw new IoTDBException(resp.status.getMessage(), resp.status.getCode());
            byte[] templateBytes = resp.getTemplate();
            Template template = new Template();
            template.deserialize(ByteBuffer.wrap(templateBytes));
            Template template2 = template;
            return template2;
        }
        catch (ClientManagerException | TException e) {
            throw new RuntimeException(new IoTDBException("get template info error.", TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode()));
        }
    }

    @Override
    public void setSchemaTemplate(String queryId, String name, PartialPath path) {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            TSetSchemaTemplateReq req = new TSetSchemaTemplateReq();
            req.setQueryId(queryId);
            req.setName(name);
            req.setPath(path.getFullPath());
            do {
                try {
                    tsStatus = configNodeClient.setSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute set schema template {} on path {} in config node, status is {}.", new Object[]{name, path, tsStatus});
                throw new IoTDBException(tsStatus.getMessage(), tsStatus.getCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<PartialPath> getPathsSetTemplate(String name) {
        ArrayList<PartialPath> listPath;
        block10: {
            listPath = new ArrayList<PartialPath>();
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TGetPathsSetTemplatesResp resp = configNodeClient.getPathsSetTemplate(name);
                if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    if (resp.getPathList() != null) {
                        resp.getPathList().forEach(item -> {
                            try {
                                listPath.add(new PartialPath(item));
                            }
                            catch (IllegalPathException e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    break block10;
                }
                throw new IoTDBException(resp.status.getMessage(), resp.status.getCode());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return listPath;
    }

    @Override
    public Template getTemplate(int id) {
        this.readWriteLock.readLock().lock();
        try {
            Template template = this.templateIdMap.get(id);
            return template;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Template, PartialPath> checkTemplateSetInfo(PartialPath devicePath) {
        this.readWriteLock.readLock().lock();
        try {
            for (PartialPath templateSetPath : this.pathSetTemplateMap.keySet()) {
                if (!devicePath.startsWithOrPrefixOf(templateSetPath.getNodes())) continue;
                Pair pair = new Pair((Object)this.templateIdMap.get(this.pathSetTemplateMap.get(templateSetPath)), (Object)templateSetPath);
                return pair;
            }
            Iterator<PartialPath> iterator = null;
            return iterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Template, PartialPath> checkTemplateSetAndPreSetInfo(PartialPath timeSeriesPath, String alias) {
        this.readWriteLock.readLock().lock();
        try {
            for (PartialPath templateSetPath : this.pathSetTemplateMap.keySet()) {
                if (timeSeriesPath.startsWithOrPrefixOf(templateSetPath.getNodes())) {
                    Pair pair = new Pair((Object)this.templateIdMap.get(this.pathSetTemplateMap.get(templateSetPath)), (Object)templateSetPath);
                    return pair;
                }
                if (alias == null || !timeSeriesPath.getDevicePath().concatNode(alias).startsWithOrPrefixOf(templateSetPath.getNodes())) continue;
                Pair pair = new Pair((Object)this.templateIdMap.get(this.pathSetTemplateMap.get(templateSetPath)), (Object)templateSetPath);
                return pair;
            }
            for (PartialPath templatePreSetPath : this.pathPreSetTemplateMap.keySet()) {
                if (timeSeriesPath.startsWithOrPrefixOf(templatePreSetPath.getNodes()) || timeSeriesPath.startsWithOrPrefixOf(timeSeriesPath.getDevicePath().concatNode(alias).getNodes())) {
                    Pair pair = new Pair((Object)this.templateIdMap.get(this.pathPreSetTemplateMap.get(templatePreSetPath)), (Object)templatePreSetPath);
                    return pair;
                }
                if (alias == null || !timeSeriesPath.getDevicePath().concatNode(alias).startsWithOrPrefixOf(templatePreSetPath.getNodes())) continue;
                Pair pair = new Pair((Object)this.templateIdMap.get(this.pathPreSetTemplateMap.get(templatePreSetPath)), (Object)templatePreSetPath);
                return pair;
            }
            Iterator<PartialPath> iterator = null;
            return iterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Template, List<PartialPath>> getAllPathsSetTemplate(String templateName) {
        this.readWriteLock.readLock().lock();
        try {
            if (!this.templateNameMap.containsKey(templateName)) {
                Pair<Template, List<PartialPath>> pair = null;
                return pair;
            }
            Template template = this.templateIdMap.get(this.templateNameMap.get(templateName));
            Pair pair = new Pair((Object)template, this.templateSetOnPathsMap.get(template.getId()));
            return pair;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Template> checkAllRelatedTemplate(PartialPath pathPattern) {
        this.readWriteLock.readLock().lock();
        try {
            HashMap<Integer, Template> result = new HashMap<Integer, Template>();
            for (Map.Entry<PartialPath, Integer> entry : this.pathSetTemplateMap.entrySet()) {
                int templateId = entry.getValue();
                Template template = this.templateIdMap.get(templateId);
                if (!this.checkIsRelated(pathPattern, entry.getKey(), template)) continue;
                result.put(templateId, template);
            }
            HashMap<Integer, Template> hashMap = result;
            return hashMap;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private boolean checkIsRelated(PartialPath pathPattern, PartialPath pathSetTemplate, Template template) {
        String measurement = pathPattern.getTailNode();
        if (PathPatternUtil.hasWildcard((String)measurement)) {
            return pathPattern.overlapWithFullPathPrefix(pathSetTemplate);
        }
        if (template.hasSchema(measurement)) {
            return pathPattern.overlapWith(pathSetTemplate.concatNode("**").concatNode(measurement)) || pathPattern.overlapWith(pathSetTemplate.concatNode(measurement));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplateSetInfo(byte[] templateSetInfo) {
        if (templateSetInfo == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            ByteBuffer buffer = ByteBuffer.wrap(templateSetInfo);
            Map<Template, List<Pair<String, Boolean>>> parsedTemplateSetInfo = TemplateInternalRPCUtil.parseAddAllTemplateSetInfoBytes(buffer);
            for (Map.Entry<Template, List<Pair<String, Boolean>>> entry : parsedTemplateSetInfo.entrySet()) {
                Template template = entry.getKey();
                this.templateIdMap.put(template.getId(), template);
                this.templateNameMap.put(template.getName(), template.getId());
                for (Pair<String, Boolean> pathSetTemplate : entry.getValue()) {
                    try {
                        PartialPath path = new PartialPath((String)pathSetTemplate.left);
                        if (((Boolean)pathSetTemplate.right).booleanValue()) {
                            this.pathPreSetTemplateMap.put(path, template.getId());
                            Set paths = this.templatePreSetOnPathsMap.computeIfAbsent(template.getId(), integer -> new HashSet());
                            paths.add(path);
                            continue;
                        }
                        this.pathSetTemplateMap.put(path, template.getId());
                        List pathList = this.templateSetOnPathsMap.computeIfAbsent(template.getId(), integer -> new ArrayList());
                        pathList.add(path);
                    }
                    catch (IllegalPathException illegalPathException) {}
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplateSetInfo(byte[] templateSetInfo) {
        if (templateSetInfo == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            ByteBuffer buffer = ByteBuffer.wrap(templateSetInfo);
            Map<Template, List<String>> parsedTemplateSetInfo = TemplateInternalRPCUtil.parseAddTemplateSetInfoBytes(buffer);
            for (Map.Entry<Template, List<String>> entry : parsedTemplateSetInfo.entrySet()) {
                Template template = entry.getKey();
                int templateId = template.getId();
                this.templateIdMap.put(templateId, template);
                this.templateNameMap.put(template.getName(), templateId);
                for (String pathSetTemplate : entry.getValue()) {
                    try {
                        PartialPath path = new PartialPath(pathSetTemplate);
                        this.pathSetTemplateMap.put(path, templateId);
                        this.templateSetOnPathsMap.computeIfAbsent(templateId, integer -> new ArrayList()).add(path);
                    }
                    catch (IllegalPathException illegalPathException) {}
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateTemplateSetInfo(byte[] templateSetInfo) {
        if (templateSetInfo == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            ByteBuffer buffer = ByteBuffer.wrap(templateSetInfo);
            Pair<Integer, String> parsedInfo = TemplateInternalRPCUtil.parseInvalidateTemplateSetInfoBytes(buffer);
            int templateId = (Integer)parsedInfo.left;
            String pathSetTemplate = (String)parsedInfo.right;
            try {
                PartialPath path = new PartialPath(pathSetTemplate);
                this.pathSetTemplateMap.remove(path);
                if (this.templateSetOnPathsMap.containsKey(templateId)) {
                    this.templateSetOnPathsMap.get(templateId).remove(path);
                    if (this.templateSetOnPathsMap.get(templateId).isEmpty()) {
                        this.templateSetOnPathsMap.remove(templateId);
                    }
                }
                this.pathPreSetTemplateMap.remove(path);
                if (this.templatePreSetOnPathsMap.containsKey(templateId)) {
                    this.templatePreSetOnPathsMap.get(templateId).remove(path);
                    if (this.templatePreSetOnPathsMap.get(templateId).isEmpty()) {
                        this.templatePreSetOnPathsMap.remove(templateId);
                    }
                }
                if (!this.templateSetOnPathsMap.containsKey(templateId) && !this.templatePreSetOnPathsMap.containsKey(templateId)) {
                    Template template = this.templateIdMap.remove(templateId);
                    this.templateNameMap.remove(template.getName());
                }
            }
            catch (IllegalPathException illegalPathException) {
                // empty catch block
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplatePreSetInfo(byte[] templateSetInfo) {
        if (templateSetInfo == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            ByteBuffer buffer = ByteBuffer.wrap(templateSetInfo);
            Map<Template, List<String>> parsedTemplateSetInfo = TemplateInternalRPCUtil.parseAddTemplateSetInfoBytes(buffer);
            for (Map.Entry<Template, List<String>> entry : parsedTemplateSetInfo.entrySet()) {
                Template template = entry.getKey();
                this.templateIdMap.put(template.getId(), template);
                this.templateNameMap.put(template.getName(), template.getId());
                for (String pathSetTemplate : entry.getValue()) {
                    try {
                        PartialPath path = new PartialPath(pathSetTemplate);
                        this.pathPreSetTemplateMap.put(path, template.getId());
                        Set pathList = this.templatePreSetOnPathsMap.computeIfAbsent(template.getId(), integer -> new HashSet());
                        pathList.add(path);
                    }
                    catch (IllegalPathException illegalPathException) {}
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTemplatePreSetInfo(byte[] templateSetInfo) {
        if (templateSetInfo == null) {
            return;
        }
        this.readWriteLock.writeLock().lock();
        try {
            ByteBuffer buffer = ByteBuffer.wrap(templateSetInfo);
            Map<Template, List<String>> parsedTemplateSetInfo = TemplateInternalRPCUtil.parseAddTemplateSetInfoBytes(buffer);
            for (Map.Entry<Template, List<String>> entry : parsedTemplateSetInfo.entrySet()) {
                Template template = entry.getKey();
                int templateId = template.getId();
                this.templateIdMap.put(templateId, template);
                this.templateNameMap.put(template.getName(), templateId);
                for (String pathSetTemplate : entry.getValue()) {
                    try {
                        PartialPath path = new PartialPath(pathSetTemplate);
                        this.pathSetTemplateMap.put(path, templateId);
                        this.templateSetOnPathsMap.computeIfAbsent(templateId, integer -> new ArrayList()).add(path);
                        this.pathPreSetTemplateMap.remove(path);
                        this.templatePreSetOnPathsMap.get(templateId).remove(path);
                        if (!this.templatePreSetOnPathsMap.get(templateId).isEmpty()) continue;
                        this.templatePreSetOnPathsMap.remove(templateId);
                    }
                    catch (IllegalPathException illegalPathException) {}
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void updateTemplateInfo(byte[] templateInfo) {
        this.readWriteLock.writeLock().lock();
        try {
            Template template = TemplateInternalRPCUtil.parseUpdateTemplateInfoBytes(ByteBuffer.wrap(templateInfo));
            this.templateIdMap.put(template.getId(), template);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalid(String database) {
        this.readWriteLock.writeLock().lock();
        try {
            Template template;
            int templateId;
            for (PartialPath fullPath : this.pathSetTemplateMap.keySet()) {
                if (!fullPath.startsWith(database)) continue;
                templateId = this.pathSetTemplateMap.remove(fullPath);
                this.templateSetOnPathsMap.get(templateId).remove(fullPath);
                if (this.templateSetOnPathsMap.get(templateId).size() != 0 || this.templatePreSetOnPathsMap.containsKey(templateId) && this.templatePreSetOnPathsMap.get(templateId).size() != 0) continue;
                this.templateSetOnPathsMap.remove(templateId);
                this.templatePreSetOnPathsMap.remove(templateId);
                template = this.templateIdMap.remove(templateId);
                this.templateNameMap.remove(template.getName());
            }
            for (PartialPath fullPath : this.pathPreSetTemplateMap.keySet()) {
                if (!fullPath.startsWith(database)) continue;
                templateId = this.pathPreSetTemplateMap.remove(fullPath);
                this.templatePreSetOnPathsMap.get(templateId).remove(fullPath);
                if (this.templateSetOnPathsMap.containsKey(templateId) && this.templateSetOnPathsMap.get(templateId).size() != 0 || this.templatePreSetOnPathsMap.get(templateId).size() != 0) continue;
                this.templateSetOnPathsMap.remove(templateId);
                this.templatePreSetOnPathsMap.remove(templateId);
                template = this.templateIdMap.remove(templateId);
                this.templateNameMap.remove(template.getName());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void putTemplate(Template template) {
        this.templateIdMap.put(template.getId(), template);
        this.templateNameMap.put(template.getName(), template.getId());
    }

    private static final class ClusterTemplateManagerHolder {
        private static final ClusterTemplateManager INSTANCE = new ClusterTemplateManager();

        private ClusterTemplateManagerHolder() {
        }
    }
}

