/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public abstract class AbstractInnerSpaceEstimator
extends AbstractCompactionEstimator {
    protected IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public long estimateInnerCompactionMemory(List<TsFileResource> resources) throws IOException {
        InnerCompactionTaskInfo taskInfo = this.calculatingCompactionTaskInfo(resources);
        long cost = this.calculatingMetadataMemoryCost(taskInfo);
        return cost += this.calculatingDataMemoryCost(taskInfo);
    }

    public abstract long calculatingMetadataMemoryCost(InnerCompactionTaskInfo var1);

    public abstract long calculatingDataMemoryCost(InnerCompactionTaskInfo var1);

    @Override
    public long estimateCrossCompactionMemory(List<TsFileResource> seqResources, TsFileResource unseqResource) throws IOException {
        throw new RuntimeException("This kind of estimator cannot be used to estimate cross space compaction task");
    }

    protected InnerCompactionTaskInfo calculatingCompactionTaskInfo(List<TsFileResource> resources) throws IOException {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (TsFileResource resource : resources) {
            TsFileSequenceReader reader = this.getFileReader(resource);
            FileInfo fileInfo = CompactionEstimateUtils.getSeriesAndDeviceChunkNum(reader);
            fileInfoList.add(fileInfo);
        }
        return new InnerCompactionTaskInfo(resources, fileInfoList);
    }

    protected static class InnerCompactionTaskInfo {
        private final List<FileInfo> fileInfoList;
        private int maxConcurrentSeriesNum = 1;
        private long maxChunkMetadataSize = 0L;
        private int maxChunkMetadataNumInDevice = 0;
        private long modificationFileSize = 0L;

        protected InnerCompactionTaskInfo(List<TsFileResource> resources, List<FileInfo> fileInfoList) {
            this.fileInfoList = fileInfoList;
            for (TsFileResource resource : resources) {
                ModificationFile modificationFile = resource.getModFile();
                if (!modificationFile.exists()) continue;
                this.modificationFileSize += modificationFile.getSize();
            }
            for (FileInfo fileInfo : fileInfoList) {
                this.maxConcurrentSeriesNum = Math.max(this.maxConcurrentSeriesNum, fileInfo.maxAlignedSeriesNumInDevice);
                this.maxChunkMetadataNumInDevice = Math.max(this.maxChunkMetadataNumInDevice, fileInfo.maxDeviceChunkNum);
                this.maxChunkMetadataSize = Math.max(this.maxChunkMetadataSize, fileInfo.averageChunkMetadataSize);
            }
        }

        public int getMaxChunkMetadataNumInDevice() {
            return this.maxChunkMetadataNumInDevice;
        }

        public long getMaxChunkMetadataSize() {
            return this.maxChunkMetadataSize;
        }

        public List<FileInfo> getFileInfoList() {
            return this.fileInfoList;
        }

        public int getMaxConcurrentSeriesNum() {
            return this.maxConcurrentSeriesNum;
        }

        public long getModificationFileSize() {
            return this.modificationFileSize;
        }
    }
}

