/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.control;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.UnClosedTsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderManager {
    private static final Logger logger = LoggerFactory.getLogger(FileReaderManager.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final int MAX_CACHED_FILE_SIZE = 30000;
    private static final int PRINT_INTERVAL = 10000;
    private Map<String, TsFileSequenceReader> closedFileReaderMap = new ConcurrentHashMap<String, TsFileSequenceReader>();
    private Map<String, TsFileSequenceReader> unclosedFileReaderMap = new ConcurrentHashMap<String, TsFileSequenceReader>();
    private Map<String, AtomicInteger> closedReferenceMap = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, AtomicInteger> unclosedReferenceMap = new ConcurrentHashMap<String, AtomicInteger>();

    private FileReaderManager() {
    }

    public static FileReaderManager getInstance() {
        return FileReaderManagerHelper.INSTANCE;
    }

    public synchronized void closeFileAndRemoveReader(String filePath) throws IOException {
        this.closedReferenceMap.remove(filePath);
        TsFileSequenceReader reader = this.closedFileReaderMap.remove(filePath);
        if (reader != null) {
            reader.close();
        }
        this.unclosedReferenceMap.remove(filePath);
        reader = this.unclosedFileReaderMap.remove(filePath);
        if (reader != null) {
            reader.close();
        }
    }

    public synchronized TsFileSequenceReader get(String filePath, boolean isClosed) throws IOException {
        Map<String, TsFileSequenceReader> readerMap;
        Map<String, TsFileSequenceReader> map = readerMap = !isClosed ? this.unclosedFileReaderMap : this.closedFileReaderMap;
        if (!readerMap.containsKey(filePath)) {
            int currentOpenedReaderCount = readerMap.size();
            if (currentOpenedReaderCount >= 30000 && currentOpenedReaderCount % 10000 == 0) {
                logger.warn("Query has opened {} files !", (Object)readerMap.size());
            }
            UnClosedTsFileReader tsFileReader = null;
            if (!isClosed) {
                tsFileReader = new UnClosedTsFileReader(filePath);
            } else {
                tsFileReader = new TsFileSequenceReader(filePath);
                if (tsFileReader.readVersionNumber() != 3) {
                    tsFileReader.close();
                    throw new IOException("The version of this TsFile is not correct.");
                }
            }
            readerMap.put(filePath, (TsFileSequenceReader)tsFileReader);
            return tsFileReader;
        }
        return readerMap.get(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        tsFile.readLock();
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed) {
                this.unclosedReferenceMap.computeIfAbsent(tsFile.getTsFilePath(), k -> new AtomicInteger()).getAndIncrement();
            } else {
                this.closedReferenceMap.computeIfAbsent(tsFile.getTsFilePath(), k -> new AtomicInteger()).getAndIncrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed && this.unclosedReferenceMap.containsKey(tsFile.getTsFilePath())) {
                if (this.unclosedReferenceMap.get(tsFile.getTsFilePath()).decrementAndGet() == 0) {
                    this.closeUnUsedReaderAndRemoveRef(tsFile.getTsFilePath(), false);
                }
            } else if (this.closedReferenceMap.containsKey(tsFile.getTsFilePath()) && this.closedReferenceMap.get(tsFile.getTsFilePath()).decrementAndGet() == 0) {
                this.closeUnUsedReaderAndRemoveRef(tsFile.getTsFilePath(), true);
            }
        }
        tsFile.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnUsedReaderAndRemoveRef(String tsFilePath, boolean isClosed) {
        Map<String, TsFileSequenceReader> readerMap = isClosed ? this.closedFileReaderMap : this.unclosedFileReaderMap;
        Map<String, AtomicInteger> refMap = isClosed ? this.closedReferenceMap : this.unclosedReferenceMap;
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (refMap.get(tsFilePath).get() != 0) {
                return;
            }
            TsFileSequenceReader reader = readerMap.get(tsFilePath);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("Can not close TsFileSequenceReader {} !", (Object)reader.getFileName(), (Object)e);
                }
            }
            readerMap.remove(tsFilePath);
            refMap.remove(tsFilePath);
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} TsFileReader is closed because of no reference.", (Object)tsFilePath);
            }
        }
    }

    public synchronized void closeAndRemoveAllOpenedReaders() throws IOException {
        Map.Entry<String, TsFileSequenceReader> entry;
        Iterator<Map.Entry<String, TsFileSequenceReader>> iterator = this.closedFileReaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getValue().close();
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} closedTsFileReader is closed.", (Object)entry.getKey());
            }
            this.closedReferenceMap.remove(entry.getKey());
            iterator.remove();
        }
        iterator = this.unclosedFileReaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getValue().close();
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} unclosedTsFileReader is closed.", (Object)entry.getKey());
            }
            this.unclosedReferenceMap.remove(entry.getKey());
            iterator.remove();
        }
    }

    public synchronized boolean contains(TsFileResource tsFile, boolean isClosed) {
        return isClosed && this.closedFileReaderMap.containsKey(tsFile.getTsFilePath()) || !isClosed && this.unclosedFileReaderMap.containsKey(tsFile.getTsFilePath());
    }

    public Map<String, TsFileSequenceReader> getClosedFileReaderMap() {
        return this.closedFileReaderMap;
    }

    public Map<String, TsFileSequenceReader> getUnclosedFileReaderMap() {
        return this.unclosedFileReaderMap;
    }

    private static class FileReaderManagerHelper {
        private static final FileReaderManager INSTANCE = new FileReaderManager();

        private FileReaderManagerHelper() {
        }
    }
}

