/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class MemAlignedPageReader
implements IPageReader,
IAlignedPageReader {
    private final TsBlock tsBlock;
    private final AlignedChunkMetadata chunkMetadata;
    private Filter valueFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private TsBlockBuilder builder;

    public MemAlignedPageReader(TsBlock tsBlock, AlignedChunkMetadata chunkMetadata, Filter filter) {
        this.tsBlock = tsBlock;
        this.chunkMetadata = chunkMetadata;
        this.valueFilter = filter;
    }

    public BatchData getAllSatisfiedPageData() throws IOException {
        return super.getAllSatisfiedPageData();
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.VECTOR, (boolean)ascending, (boolean)false);
        for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
            Object firstNotNullObject = this.getFirstNotNullObject(row);
            if (firstNotNullObject == null) continue;
            this.doFilter(firstNotNullObject, row, batchData);
        }
        return batchData.flip();
    }

    private Object getFirstNotNullObject(int rowIndex) {
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            if (this.tsBlock.getColumn(column).isNull(rowIndex)) continue;
            return this.tsBlock.getColumn(column).getObject(rowIndex);
        }
        return null;
    }

    private void doFilter(Object row, int rowIndex, BatchData batchData) {
        if (this.valueFilter == null || this.valueFilter.satisfy(this.tsBlock.getTimeByIndex(rowIndex), row)) {
            TsPrimitiveType[] values = new TsPrimitiveType[this.tsBlock.getValueColumnCount()];
            for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
                if (this.tsBlock.getColumn(column) == null || this.tsBlock.getColumn(column).isNull(rowIndex)) continue;
                values[column] = this.tsBlock.getColumn(column).getTsPrimitiveType(rowIndex);
            }
            batchData.putVector(this.tsBlock.getTimeByIndex(rowIndex), values);
        }
    }

    private boolean pageSatisfy() {
        if (this.valueFilter != null) {
            return this.valueFilter.satisfy(this.getStatistics());
        }
        long rowCount = this.getTimeStatistics().getCount();
        for (Statistics<? extends Serializable> statistics : this.getValueStatisticsList()) {
            if (statistics != null && !statistics.hasNullValue(rowCount)) continue;
            return true;
        }
        if (this.paginationController.hasCurOffset(rowCount)) {
            this.paginationController.consumeOffset(rowCount);
            return false;
        }
        return true;
    }

    public TsBlock getAllSatisfiedData() {
        this.builder.reset();
        if (!this.pageSatisfy()) {
            return this.builder.build();
        }
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        boolean[] hasValue = this.buildHasValueArray();
        int readEndIndex = this.buildTimeColumn(satisfyInfo, hasValue);
        this.buildValueColumns(satisfyInfo, hasValue, readEndIndex);
        return this.builder.build();
    }

    private boolean[] buildSatisfyInfoArray() {
        boolean[] satisfyInfo = new boolean[this.tsBlock.getPositionCount()];
        for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
            long time = this.tsBlock.getTimeByIndex(row);
            if (this.valueFilter != null && !this.valueFilter.satisfy(time, null)) continue;
            satisfyInfo[row] = true;
        }
        return satisfyInfo;
    }

    private boolean[] buildHasValueArray() {
        boolean[] hasValue = new boolean[this.tsBlock.getPositionCount()];
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                hasValue[row] = hasValue[row] || !valueColumn.isNull(row);
            }
        }
        return hasValue;
    }

    private int buildTimeColumn(boolean[] satisfyInfo, boolean[] hasValue) {
        int readEndIndex = this.tsBlock.getPositionCount();
        for (int row = 0; row < readEndIndex; ++row) {
            if (this.needSkipCurrentRow(satisfyInfo, hasValue, row)) continue;
            if (this.paginationController.hasCurLimit()) {
                this.builder.getTimeColumnBuilder().writeLong(this.tsBlock.getTimeByIndex(row));
                this.builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = row;
        }
        return readEndIndex;
    }

    private boolean needSkipCurrentRow(boolean[] satisfyInfo, boolean[] hasValue, int rowIndex) {
        if (!satisfyInfo[rowIndex] || !hasValue[rowIndex]) {
            return true;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            satisfyInfo[rowIndex] = false;
            return true;
        }
        return false;
    }

    private void buildValueColumns(boolean[] satisfyInfo, boolean[] hasValue, int readEndIndex) {
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            ColumnBuilder valueBuilder = this.builder.getColumnBuilder(column);
            for (int row = 0; row < readEndIndex; ++row) {
                if (!satisfyInfo[row] || !hasValue[row]) continue;
                if (!valueColumn.isNull(row)) {
                    valueBuilder.write(valueColumn, row);
                    continue;
                }
                valueBuilder.appendNull();
            }
        }
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public Statistics<? extends Serializable> getStatistics(int index) {
        return this.chunkMetadata.getStatistics(index);
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.chunkMetadata.getTimeStatistics();
    }

    private List<Statistics<? extends Serializable>> getValueStatisticsList() {
        return this.chunkMetadata.getValueStatisticsList();
    }

    public void setFilter(Filter filter) {
        this.valueFilter = this.valueFilter == null ? filter : new AndFilter(this.valueFilter, filter);
    }

    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = new TsBlockBuilder(dataTypes);
    }
}

