/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.common;

import java.io.IOException;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.Element;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.PriorityMergeReader;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;

public class CachedPriorityMergeReader
extends PriorityMergeReader {
    private static final int CACHE_SIZE = 100;
    private TimeValuePair[] timeValuePairCache = new TimeValuePair[100];
    private int cacheLimit = 0;
    private int cacheIdx = 0;
    private Long lastTimestamp = null;

    public CachedPriorityMergeReader(TSDataType dataType) {
        for (int i = 0; i < 100; ++i) {
            this.timeValuePairCache[i] = TimeValuePairUtils.getEmptyTimeValuePair(dataType);
        }
    }

    @Override
    public boolean hasNextTimeValuePair() {
        return this.cacheIdx < this.cacheLimit || !this.heap.isEmpty();
    }

    private void fetch() throws IOException {
        this.cacheLimit = 0;
        this.cacheIdx = 0;
        while (!this.heap.isEmpty() && this.cacheLimit < 100) {
            Element top = (Element)this.heap.peek();
            if (this.lastTimestamp == null || top.currTime() != this.lastTimestamp.longValue()) {
                TimeValuePairUtils.setTimeValuePair(top.getTimeValuePair(), this.timeValuePairCache[this.cacheLimit++]);
                this.lastTimestamp = top.currTime();
            }
            while (this.heap.peek() != null && ((Element)this.heap.peek()).currTime() == this.lastTimestamp.longValue()) {
                top = (Element)this.heap.poll();
                if (top.hasNext()) {
                    top.next();
                    this.heap.add(top);
                    continue;
                }
                top.close();
            }
        }
    }

    @Override
    public TimeValuePair nextTimeValuePair() throws IOException {
        TimeValuePair ret;
        if (this.cacheIdx < this.cacheLimit) {
            ret = this.timeValuePairCache[this.cacheIdx++];
        } else {
            this.fetch();
            ret = this.timeValuePairCache[this.cacheIdx++];
        }
        return ret;
    }

    @Override
    public TimeValuePair currentTimeValuePair() throws IOException {
        if (0 <= this.cacheIdx && this.cacheIdx < this.cacheLimit) {
            return this.timeValuePairCache[this.cacheIdx];
        }
        this.fetch();
        return this.timeValuePairCache[this.cacheIdx];
    }
}

