/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.buffer;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;

public class WALSignalEntry
extends WALEntry {
    public WALSignalEntry(WALEntryType signalType) {
        this(signalType, false);
    }

    public WALSignalEntry(WALEntryType signalType, boolean wait) {
        super(signalType, Long.MIN_VALUE, null, wait);
        switch (signalType) {
            case INSERT_TABLET_PLAN: 
            case INSERT_TABLET_NODE: 
            case INSERT_ROW_PLAN: 
            case INSERT_ROW_NODE: 
            case DELETE_PLAN: 
            case MEMORY_TABLE_SNAPSHOT: {
                throw new RuntimeException("Cannot use wal info type as wal signal type");
            }
        }
    }

    @Override
    public int serializedSize() {
        return 1;
    }

    @Override
    public void serialize(IWALByteBufferView buffer) {
        buffer.put(this.type.getCode());
    }

    public void serialize(ByteBuffer buffer) {
        buffer.put(this.type.getCode());
    }

    @Override
    public boolean isSignal() {
        return true;
    }
}

