/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALSignalEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.LogWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALMetaData;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileStatus;

public class WALWriter
extends LogWriter {
    public static final String MAGIC_STRING = "WAL";
    public static final int MAGIC_STRING_BYTES = "WAL".getBytes().length;
    private WALFileStatus walFileStatus = WALFileStatus.CONTAINS_NONE_SEARCH_INDEX;
    protected final WALMetaData metaData = new WALMetaData();

    public WALWriter(File logFile) throws FileNotFoundException {
        super(logFile);
    }

    public void write(ByteBuffer buffer, WALMetaData metaData) throws IOException {
        this.updateMetaData(metaData);
        this.write(buffer);
    }

    public void updateMetaData(WALMetaData metaData) {
        this.metaData.addAll(metaData);
    }

    private void endFile() throws IOException {
        WALSignalEntry endMarker = new WALSignalEntry(WALEntryType.WAL_FILE_INFO_END_MARKER);
        int metaDataSize = this.metaData.serializedSize();
        ByteBuffer buffer = ByteBuffer.allocate(endMarker.serializedSize() + metaDataSize + 4 + MAGIC_STRING_BYTES);
        endMarker.serialize(buffer);
        this.metaData.serialize(buffer);
        buffer.putInt(metaDataSize);
        buffer.put(MAGIC_STRING.getBytes());
        this.write(buffer);
    }

    @Override
    public void close() throws IOException {
        this.endFile();
        super.close();
    }

    public void updateFileStatus(WALFileStatus walFileStatus) {
        if (walFileStatus == WALFileStatus.CONTAINS_SEARCH_INDEX) {
            this.walFileStatus = WALFileStatus.CONTAINS_SEARCH_INDEX;
        }
    }

    public WALFileStatus getWalFileStatus() {
        return this.walFileStatus;
    }
}

