/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;

public class WALEntryPosition {
    private static final WALInsertNodeCache CACHE = WALInsertNodeCache.getInstance();
    private volatile String identifier = "";
    private volatile long walFileVersionId = -1L;
    private volatile long position;
    private volatile int size;
    private WALNode walNode = null;
    private File walFile = null;

    public WALEntryPosition() {
    }

    public WALEntryPosition(String identifier, long walFileVersionId, long position, int size) {
        this.identifier = identifier;
        this.walFileVersionId = walFileVersionId;
        this.position = position;
        this.size = size;
    }

    public InsertNode readInsertNodeViaCache() throws IOException {
        if (!this.canRead()) {
            throw new IOException("This entry isn't ready for read.");
        }
        return CACHE.get(this);
    }

    ByteBuffer read() throws IOException {
        if (!this.canRead()) {
            throw new IOException("Target file hasn't been specified.");
        }
        try (FileChannel channel = this.openReadFileChannel();){
            ByteBuffer buffer = ByteBuffer.allocate(this.size);
            channel.position(this.position);
            channel.read(buffer);
            buffer.clear();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public FileChannel openReadFileChannel() throws IOException {
        if (this.isInSealedFile()) {
            this.walFile = this.walNode.getWALFile(this.walFileVersionId);
            return FileChannel.open(this.walFile.toPath(), StandardOpenOption.READ);
        }
        try {
            this.walFile = this.walNode.getWALFile(this.walFileVersionId);
            return FileChannel.open(this.walFile.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            if (this.isInSealedFile()) {
                this.walFile = this.walNode.getWALFile(this.walFileVersionId);
                return FileChannel.open(this.walFile.toPath(), StandardOpenOption.READ);
            }
            throw e;
        }
    }

    public boolean canRead() {
        return this.walFileVersionId >= 0L;
    }

    public boolean isInSealedFile() {
        if (this.walNode == null || !this.canRead()) {
            throw new RuntimeException("This entry isn't ready for read.");
        }
        return this.walFileVersionId < this.walNode.getCurrentWALFileVersion();
    }

    public void setWalNode(WALNode walNode) {
        this.walNode = walNode;
        this.identifier = walNode.getIdentifier();
    }

    public void setEntryPosition(long walFileVersionId, long position) {
        this.position = position;
        this.walFileVersionId = walFileVersionId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public long getWalFileVersionId() {
        return this.walFileVersionId;
    }

    public File getWalFile() {
        return this.walFile;
    }

    public long getPosition() {
        return this.position;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.walFileVersionId, this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WALEntryPosition that = (WALEntryPosition)o;
        return this.identifier.equals(that.identifier) && this.walFileVersionId == that.walFileVersionId && this.position == that.position;
    }
}

