/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.quotas;

public abstract class RateLimiter {
    private long tunit = 1000L;
    private long limit = Long.MAX_VALUE;
    private long avail = Long.MAX_VALUE;

    public synchronized void set(long limit, long tunit) {
        this.tunit = tunit;
        this.limit = limit;
        this.avail = limit;
    }

    public synchronized boolean canExecute(long amount) {
        if (this.limit == Long.MAX_VALUE) {
            return true;
        }
        long refillAmount = this.refill(this.limit);
        if (refillAmount == 0L && this.avail < amount) {
            return false;
        }
        this.avail = this.avail <= Long.MAX_VALUE - refillAmount ? Math.max(0L, Math.min(this.avail + refillAmount, this.limit)) : Math.max(0L, this.limit);
        return this.avail >= amount;
    }

    abstract long refill(long var1);

    abstract long getWaitInterval(long var1, long var3, long var5);

    public synchronized long getTimeUnitInMillis() {
        return this.tunit;
    }

    public synchronized long getLimit() {
        return this.limit;
    }

    public synchronized long getAvailable() {
        return this.avail;
    }

    public long waitInterval() {
        return this.waitInterval(1L);
    }

    public synchronized long waitInterval(long amount) {
        return amount <= this.avail ? 0L : this.getWaitInterval(this.getLimit(), this.avail, amount);
    }

    public synchronized void consume(long amount) {
        if (amount >= 0L) {
            this.avail -= amount;
            if (this.avail < 0L) {
                this.avail = 0L;
            }
        } else if (this.avail <= Long.MAX_VALUE + amount) {
            this.avail -= amount;
            this.avail = Math.min(this.avail, this.limit);
        } else {
            this.avail = this.limit;
        }
    }
}

